/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.jvm;

import io.quarkus.deployment.jvm.JVMDeploymentLogger;
import java.util.concurrent.ConcurrentHashMap;

final class ModulesClassloaderContext {
    private final Module classloaderUnnamedModule;
    private final ModuleLayer currentLayer;
    private final ConcurrentHashMap<String, Module> moduleCache = new ConcurrentHashMap();

    public ModulesClassloaderContext(ClassLoader classloader) {
        Module unnamedModule;
        this.classloaderUnnamedModule = unnamedModule = classloader.getUnnamedModule();
        this.currentLayer = ModulesClassloaderContext.currentLayer(unnamedModule);
    }

    public Module findModule(String moduleName) {
        return this.moduleCache.computeIfAbsent(moduleName, this::findOrFallbackModule);
    }

    private Module findOrFallbackModule(String moduleName) {
        return this.currentLayer.findModule(moduleName).orElseGet(() -> {
            JVMDeploymentLogger.logger.debugf("Module %s not found, falling back to unnamed module", (Object)moduleName);
            return this.classloaderUnnamedModule;
        });
    }

    private static ModuleLayer currentLayer(Module module) {
        ModuleLayer layer = module.getLayer();
        if (layer == null) {
            return ModuleLayer.boot();
        }
        return layer;
    }
}

