/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.ModelResolutionTask;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskErrorHandler;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskRunner;

class BlockingModelResolutionTaskRunner
implements ModelResolutionTaskRunner {
    private final ModelResolutionTaskErrorHandler errorHandler;

    static BlockingModelResolutionTaskRunner getInstance() {
        return new BlockingModelResolutionTaskRunner(null);
    }

    static BlockingModelResolutionTaskRunner getInstance(ModelResolutionTaskErrorHandler errorHandler) {
        return new BlockingModelResolutionTaskRunner(errorHandler);
    }

    BlockingModelResolutionTaskRunner(ModelResolutionTaskErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void run(ModelResolutionTask task) {
        if (this.errorHandler == null) {
            task.run();
            return;
        }
        try {
            task.run();
        }
        catch (Exception e) {
            this.errorHandler.handleError(task, e);
        }
    }

    @Override
    public void waitForCompletion() {
        if (this.errorHandler != null) {
            this.errorHandler.allTasksFinished();
        }
    }
}

