/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifact;

public class AppDependency {
    private final AppArtifact artifact;
    private final String scope;
    private final boolean optional;

    public AppDependency(AppArtifact artifact, String scope) {
        this(artifact, scope, false);
    }

    public AppDependency(AppArtifact artifact, String scope, boolean optional) {
        this.artifact = artifact;
        this.scope = scope;
        this.optional = optional;
    }

    public AppArtifact getArtifact() {
        return this.artifact;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppDependency other = (AppDependency)obj;
        if (this.artifact == null ? other.artifact != null : !this.artifact.equals(other.artifact)) {
            return false;
        }
        if (this.optional != other.optional) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.artifact.append(buf).append('(').append(this.scope);
        if (this.optional) {
            buf.append(" optional");
        }
        return buf.append(')').toString();
    }
}

