/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.Mappable;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.model.PlatformReleaseInfo;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface PlatformImports
extends Mappable {
    public static PlatformImports fromMap(Map<String, Object> map) {
        return new PlatformImportsImpl(map.getOrDefault("platform-properties", Collections.emptyMap()), PlatformImports.importedBomsFromMap(map), PlatformImports.releaseInfoFromMap(map));
    }

    private static List<ArtifactCoords> importedBomsFromMap(Map<String, Object> map) {
        Collection importedBomsStr = (Collection)map.get("imported-boms");
        if (importedBomsStr != null) {
            ArrayList<ArtifactCoords> importedBoms = new ArrayList<ArtifactCoords>(importedBomsStr.size());
            for (String importedBomStr : importedBomsStr) {
                importedBoms.add(ArtifactCoords.fromString(importedBomStr));
            }
            return importedBoms;
        }
        return Collections.emptyList();
    }

    private static List<PlatformReleaseInfo> releaseInfoFromMap(Map<String, Object> map) {
        Collection releaseInfoCol = (Collection)map.get("release-info");
        if (releaseInfoCol != null) {
            ArrayList<PlatformReleaseInfo> releaseInfo = new ArrayList<PlatformReleaseInfo>(releaseInfoCol.size());
            for (Map releaseInfoMap : releaseInfoCol) {
                releaseInfo.add(PlatformReleaseInfo.fromMap(releaseInfoMap));
            }
            return releaseInfo;
        }
        return Collections.emptyList();
    }

    public Map<String, String> getPlatformProperties();

    public Collection<PlatformReleaseInfo> getPlatformReleaseInfo();

    public Collection<ArtifactCoords> getImportedPlatformBoms();

    public String getMisalignmentReport();

    public boolean isAligned();

    @Override
    default public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Map<String, Object> map = factory.newMap(3);
        if (!this.getPlatformProperties().isEmpty()) {
            Map<String, String> props = this.getPlatformProperties();
            Map<String, Object> jsonProps = factory.newMap(props.size());
            jsonProps.putAll(props);
            map.put("platform-properties", jsonProps);
        }
        if (this.getPlatformReleaseInfo() != null) {
            map.put("release-info", Mappable.asMaps(this.getPlatformReleaseInfo(), factory));
        }
        if (this.getImportedPlatformBoms() != null) {
            map.put("imported-boms", Mappable.toStringCollection(this.getImportedPlatformBoms(), ArtifactCoords::toGACTVString, factory));
        }
        return map;
    }
}

