/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.maven.dependency.ArtifactKey;

public interface ArtifactCoords {
    public static final String TYPE_JAR = "jar";
    public static final String TYPE_POM = "pom";

    public String getGroupId();

    public String getArtifactId();

    public String getClassifier();

    public String getType();

    public String getVersion();

    public ArtifactKey getKey();

    default public String toGACTVString() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getClassifier() + ":" + this.getType() + ":" + this.getVersion();
    }

    default public String toCompactCoords() {
        StringBuilder b = new StringBuilder();
        b.append(this.getGroupId()).append(':').append(this.getArtifactId()).append(':');
        if (!this.getClassifier().isEmpty()) {
            b.append(this.getClassifier()).append(':');
        }
        if (!TYPE_JAR.equals(this.getType())) {
            b.append(this.getType()).append(':');
        }
        b.append(this.getVersion());
        return b.toString();
    }
}

