/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

public class StringUtils {
    private static final String CONCAT_DELIMITER = "; ";

    public static String hashSHA256(String input) {
        if (StringUtils.isBlank(input)) {
            return "4veeW2AzC7pMKJliIxtropV9CxTn3rMRBBcAPHnepjU=";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            return "N/A";
        }
    }

    private static boolean isBlank(String input) {
        return input == null || input.isBlank();
    }

    public static String concat(List<String> stringList) {
        if (stringList.isEmpty()) {
            return "N/A";
        }
        return stringList.stream().collect(Collectors.joining(CONCAT_DELIMITER));
    }
}

