/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.RoleRef;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.config.workflow.WorkflowSpec;
import io.javaoperatorsdk.operator.processing.event.rate.LinearRateLimiter;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.runtime.DependentResourceSpecMetadata;
import io.quarkiverse.operatorsdk.runtime.ExternalGradualRetryConfiguration;
import io.quarkiverse.operatorsdk.runtime.ExternalGradualRetryIntervalConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusInformerConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusManagedWorkflow;
import io.quarkiverse.operatorsdk.runtime.QuarkusWorkflowSpec;
import io.quarkus.logging.Log;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class QuarkusBuildTimeControllerConfiguration<R extends HasMetadata>
implements ControllerConfiguration<R> {
    private final String associatedReconcilerClassName;
    private final String name;
    private final String resourceTypeName;
    private final boolean generationAware;
    private final boolean statusPresentAndNotVoid;
    private final Class<R> resourceClass;
    private final List<PolicyRule> additionalRBACRules;
    private final List<RoleRef> additionalRBACRoleRefs;
    private final String fieldManager;
    private Optional<Duration> maxReconciliationInterval;
    private String finalizer;
    private boolean wereNamespacesSet;
    private final Retry retry;
    private final RateLimiter rateLimiter;
    private QuarkusManagedWorkflow<R> workflow;
    private ConfigurationService parent;
    private QuarkusInformerConfiguration<R> informerConfig;

    @RecordableConstructor
    public QuarkusBuildTimeControllerConfiguration(String associatedReconcilerClassName, String name, String resourceTypeName, boolean generationAware, Class resourceClass, boolean wereNamespacesSet, String finalizerName, boolean statusPresentAndNotVoid, Duration maxReconciliationInterval, Retry retry, RateLimiter rateLimiter, List<PolicyRule> additionalRBACRules, List<RoleRef> additionalRBACRoleRefs, String fieldManager, QuarkusInformerConfiguration<R> informerConfig) {
        this.informerConfig = informerConfig;
        this.associatedReconcilerClassName = associatedReconcilerClassName;
        this.name = name;
        this.resourceTypeName = resourceTypeName;
        this.generationAware = generationAware;
        this.resourceClass = resourceClass;
        this.additionalRBACRules = additionalRBACRules;
        this.additionalRBACRoleRefs = additionalRBACRoleRefs;
        this.setNamespaces(informerConfig.getNamespaces());
        this.wereNamespacesSet = wereNamespacesSet;
        this.setFinalizer(finalizerName);
        this.statusPresentAndNotVoid = statusPresentAndNotVoid;
        this.maxReconciliationInterval = maxReconciliationInterval != null ? Optional.of(maxReconciliationInterval) : super.maxReconciliationInterval();
        this.retry = retry == null ? new GenericRetry() : retry;
        this.rateLimiter = rateLimiter == null ? new DefaultRateLimiter() : rateLimiter;
        this.fieldManager = fieldManager != null ? fieldManager : super.fieldManager();
    }

    @IgnoreProperty
    public ConfigurationService getConfigurationService() {
        return this.parent;
    }

    public void setParent(ConfigurationService parent) {
        this.parent = parent;
    }

    public Class<R> getResourceClass() {
        return this.resourceClass;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public String getFinalizerName() {
        return this.finalizer;
    }

    public void setFinalizer(String finalizer) {
        this.finalizer = finalizer != null && !finalizer.isBlank() ? finalizer : ReconcilerUtils.getDefaultFinalizerName((String)this.resourceTypeName);
    }

    public boolean isGenerationAware() {
        return this.generationAware;
    }

    public String getAssociatedReconcilerClassName() {
        return this.associatedReconcilerClassName;
    }

    void setNamespaces(Set<String> namespaces) {
        if (!namespaces.equals(this.informerConfig.getNamespaces())) {
            this.informerConfig = new QuarkusInformerConfiguration(InformerConfiguration.builder(this.informerConfig).withNamespaces(namespaces).buildForController());
            this.wereNamespacesSet = true;
        }
    }

    public boolean isWereNamespacesSet() {
        return this.wereNamespacesSet;
    }

    @IgnoreProperty
    public Set<String> getEffectiveNamespaces() {
        return super.getEffectiveNamespaces();
    }

    void setLabelSelector(String labelSelector) {
        this.informerConfig = new QuarkusInformerConfiguration(InformerConfiguration.builder(this.informerConfig).withLabelSelector(labelSelector).buildForController());
    }

    public boolean isStatusPresentAndNotVoid() {
        return this.statusPresentAndNotVoid;
    }

    public boolean areDependentsImpactedBy(Set<String> changedClasses) {
        return this.dependentsMetadata().keySet().parallelStream().anyMatch(changedClasses::contains);
    }

    public boolean needsDependentBeansCreation() {
        Map<String, DependentResourceSpecMetadata> dependentsMetadata = this.dependentsMetadata();
        return dependentsMetadata != null && !dependentsMetadata.isEmpty();
    }

    public QuarkusManagedWorkflow<R> getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(QuarkusManagedWorkflow<R> workflow) {
        this.workflow = workflow;
    }

    public Object getConfigurationFor(DependentResourceSpec dependentResourceSpec) {
        return dependentResourceSpec.getConfiguration().orElse(null);
    }

    public Optional<WorkflowSpec> getWorkflowSpec() {
        return this.workflow.getGenericSpec();
    }

    public Retry getRetry() {
        return this.retry;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public Optional<Duration> maxReconciliationInterval() {
        return this.maxReconciliationInterval;
    }

    public Duration getMaxReconciliationInterval() {
        return this.maxReconciliationInterval.orElseThrow();
    }

    void setMaxReconciliationInterval(Duration duration) {
        this.maxReconciliationInterval = Optional.of(duration);
    }

    public OnAddFilter<? super R> getOnAddFilter() {
        return this.getInformerConfig().getOnAddFilter();
    }

    public OnUpdateFilter<? super R> getOnUpdateFilter() {
        return this.getInformerConfig().getOnUpdateFilter();
    }

    public GenericFilter<? super R> getGenericFilter() {
        return this.getInformerConfig().getGenericFilter();
    }

    public Map<String, DependentResourceSpecMetadata> dependentsMetadata() {
        return this.workflow.getSpec().map(QuarkusWorkflowSpec::getDependentResourceSpecMetadata).orElse(Collections.emptyMap());
    }

    void updateRetryConfiguration(ExternalGradualRetryConfiguration externalGradualRetryConfiguration) {
        if (externalGradualRetryConfiguration != null) {
            Retry retry = this.retry;
            if (!(retry instanceof GenericRetry)) {
                Log.warn((Object)("Retry configuration in application.properties is only appropriate when using the GenericRetry implementation, yet your Reconciler is configured to use " + this.retry.getClass().getName() + " as Retry implementation. Configuration from application.properties will therefore be ignored."));
                return;
            }
            GenericRetry genericRetry = (GenericRetry)retry;
            externalGradualRetryConfiguration.maxAttempts().ifPresent(arg_0 -> ((GenericRetry)genericRetry).setMaxAttempts(arg_0));
            ExternalGradualRetryIntervalConfiguration intervalConfiguration = externalGradualRetryConfiguration.interval();
            intervalConfiguration.initial().ifPresent(arg_0 -> ((GenericRetry)genericRetry).setInitialInterval(arg_0));
            intervalConfiguration.max().ifPresent(arg_0 -> ((GenericRetry)genericRetry).setMaxInterval(arg_0));
            intervalConfiguration.multiplier().ifPresent(arg_0 -> ((GenericRetry)genericRetry).setIntervalMultiplier(arg_0));
        }
    }

    public List<PolicyRule> getAdditionalRBACRules() {
        return this.additionalRBACRules;
    }

    public List<RoleRef> getAdditionalRBACRoleRefs() {
        return this.additionalRBACRoleRefs;
    }

    public String getFieldManager() {
        return this.fieldManager;
    }

    public String fieldManager() {
        return this.fieldManager;
    }

    public ItemStore<R> getNullableItemStore() {
        return this.getInformerConfig().getItemStore();
    }

    public InformerConfiguration<R> getInformerConfig() {
        return this.informerConfig;
    }

    public static final class DefaultRateLimiter
    extends LinearRateLimiter {
        public DefaultRateLimiter() {
        }

        @RecordableConstructor
        public DefaultRateLimiter(Duration refreshPeriod, int limitForPeriod) {
            super(refreshPeriod, limitForPeriod);
        }
    }
}

