/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ControllerConfigurationOverrider;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDUtils;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkiverse.operatorsdk.runtime.api.ConfigurableReconciler;
import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OperatorProducer {
    private static final Logger log = LoggerFactory.getLogger(OperatorProducer.class);

    private static <P extends HasMetadata> void register(QuarkusConfigurationService configurationService, Reconciler<P> reconciler, Operator operator) {
        if (reconciler instanceof ConfigurableReconciler) {
            ConfigurableReconciler configurable = (ConfigurableReconciler)reconciler;
            ControllerConfiguration conf = configurationService.getConfigurationFor((Reconciler)reconciler);
            if (conf != null) {
                ControllerConfigurationOverrider override = ControllerConfigurationOverrider.override((ControllerConfiguration)conf);
                configurable.updateConfigurationFrom(override);
                ControllerConfiguration updated = override.build();
                Duration maxReconciliationInterval = updated.maxReconciliationInterval().orElse(Duration.ofHours(10L));
                QuarkusControllerConfiguration qConf = new QuarkusControllerConfiguration(updated.getInformerConfig(), updated.getName(), updated.isGenerationAware(), conf.getAssociatedReconcilerClassName(), updated.getRetry(), updated.getRateLimiter(), maxReconciliationInterval, updated.getFinalizerName(), updated.fieldManager(), conf.getWorkflow(), conf.getResourceTypeName(), conf.getResourceClass());
                qConf.setParent(configurationService);
                operator.register(reconciler, qConf);
                return;
            }
        }
        operator.register(reconciler);
    }

    @Produces
    @DefaultBean
    @ApplicationScoped
    Operator operator(QuarkusConfigurationService configuration, Instance<Reconciler<? extends HasMetadata>> reconcilers) {
        CRDGenerationInfo crdInfo;
        io.javaoperatorsdk.operator.api.config.Version version = configuration.getVersion();
        if (version instanceof Version) {
            Version version2 = (Version)version;
            log.info("Quarkus Java Operator SDK extension {}", (Object)version2.getExtensionCompleteVersion());
        }
        if ((crdInfo = configuration.getCRDGenerationInfo()).isApplyCRDs()) {
            for (String string : crdInfo.getGenerated()) {
                CRDUtils.applyCRD(configuration.getKubernetesClient(), crdInfo, string);
            }
        }
        Operator operator = new Operator((ConfigurationService)configuration);
        for (Reconciler reconciler : reconcilers) {
            OperatorProducer.register(configuration, reconciler, operator);
        }
        int n = configuration.getTerminationTimeoutSeconds();
        if (-1 != n) {
            operator.installShutdownHook(Duration.ofSeconds(n));
        }
        return operator;
    }
}

