/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.HelmConfiguration;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.operator-sdk")
@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public interface BuildTimeOperatorConfiguration {
    public Map<String, BuildTimeControllerConfiguration> controllers();

    public CRDConfiguration crd();

    @WithDefault(value="true")
    public Optional<Boolean> generationAware();

    @WithDefault(value="false")
    public Boolean disableRbacGeneration();

    @WithDefault(value="true")
    public Boolean startOperator();

    @WithDefault(value="true")
    public Boolean closeClientOnStop();

    @WithDefault(value="true")
    public Boolean stopOnInformerErrorDuringStartup();

    @WithDefault(value="false")
    public Boolean failOnVersionCheck();

    @WithDefault(value="prod")
    public List<String> activateLeaderElectionForProfiles();

    @WithName(value="enable-ssa")
    @WithDefault(value="true")
    public boolean enableSSA();

    @WithDefault(value="false")
    public boolean defensiveCloning();

    public Optional<List<String>> generateWithWatchedNamespaces();

    public HelmConfiguration helm();

    default public boolean isControllerOwningPrimary(String controllerName) {
        BuildTimeControllerConfiguration controllerConfiguration = this.controllers().get(controllerName);
        return controllerConfiguration == null || !controllerConfiguration.unownedPrimary();
    }
}

