/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jooq.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkiverse.jooq.runtime.DslContextFactory;
import io.quarkiverse.jooq.runtime.JooqCustomContext;
import jakarta.inject.Qualifier;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.jooq.DSLContext;

public abstract class AbstractDslContextProducer {
    private static final Logger log = Logger.getLogger(AbstractDslContextProducer.class);

    public DSLContext createDslContext(String sqlDialect, AgroalDataSource dataSource, String customConfiguration) {
        Objects.requireNonNull(sqlDialect, "sqlDialect");
        Objects.requireNonNull(dataSource, "dataSource");
        if (customConfiguration == null || customConfiguration.isEmpty()) {
            return this.createDslContext(sqlDialect, dataSource, new JooqCustomContext(){});
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = JooqCustomContext.class.getClassLoader();
        }
        try {
            Class<?> clazz = cl.loadClass(customConfiguration);
            JooqCustomContext instance = (JooqCustomContext)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.createDslContext(sqlDialect, dataSource, instance);
        }
        catch (Exception e) {
            log.error((Object)customConfiguration, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DSLContext createDslContext(String sqlDialect, AgroalDataSource dataSource, JooqCustomContext customConfiguration) {
        Objects.requireNonNull(sqlDialect, "sqlDialect");
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(customConfiguration, "customConfiguration");
        return DslContextFactory.create(sqlDialect, dataSource, customConfiguration);
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Qualifier
    public static @interface DslContextQualifier {
        public String value();
    }
}

