/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.http.HttpInfos;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public interface HttpServerResponse
extends NettyOutbound,
HttpInfos {
    public HttpServerResponse addCookie(Cookie var1);

    public HttpServerResponse addHeader(CharSequence var1, CharSequence var2);

    public HttpServerResponse chunkedTransfer(boolean var1);

    @Override
    default public HttpServerResponse context(Consumer<NettyContext> contextCallback) {
        contextCallback.accept(this.context());
        return this;
    }

    public HttpServerResponse compression(boolean var1);

    public boolean hasSentHeaders();

    public HttpServerResponse header(CharSequence var1, CharSequence var2);

    public HttpServerResponse headers(HttpHeaders var1);

    public HttpServerResponse keepAlive(boolean var1);

    @Override
    default public HttpServerResponse onWriteIdle(long idleTimeout, Runnable onWriteIdle) {
        NettyOutbound.super.onWriteIdle(idleTimeout, onWriteIdle);
        return this;
    }

    @Override
    default public HttpServerResponse options(Consumer<? super NettyPipeline.SendOptions> configurator) {
        NettyOutbound.super.options(configurator);
        return this;
    }

    public HttpHeaders responseHeaders();

    default public Mono<Void> send() {
        return this.sendObject(Unpooled.EMPTY_BUFFER).then();
    }

    public NettyOutbound sendHeaders();

    public Mono<Void> sendNotFound();

    public Mono<Void> sendRedirect(String var1);

    default public Mono<Void> sendWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.sendWebsocket(this.uri(), websocketHandler);
    }

    public Mono<Void> sendWebsocket(String var1, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> var2);

    public HttpServerResponse sse();

    public HttpResponseStatus status();

    public HttpServerResponse status(HttpResponseStatus var1);

    default public HttpServerResponse status(int status) {
        return this.status(HttpResponseStatus.valueOf((int)status));
    }
}

