/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InternalTelemetryVersion;
import io.opentelemetry.sdk.internal.ComponentId;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.LogRecordProcessorInstrumentation;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessorBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleLogRecordProcessor
implements LogRecordProcessor {
    private static final ComponentId COMPONENT_ID = ComponentId.generateLazy((String)"simple_log_processor");
    private static final Logger logger = Logger.getLogger(SimpleLogRecordProcessor.class.getName());
    private final LogRecordExporter logRecordExporter;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final LogRecordProcessorInstrumentation logProcessorInstrumentation;
    private final Object exporterLock = new Object();

    public static LogRecordProcessor create(LogRecordExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return SimpleLogRecordProcessor.builder(exporter).build();
    }

    public static SimpleLogRecordProcessorBuilder builder(LogRecordExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return new SimpleLogRecordProcessorBuilder(exporter);
    }

    SimpleLogRecordProcessor(LogRecordExporter logRecordExporter, Supplier<MeterProvider> meterProvider) {
        this.logRecordExporter = Objects.requireNonNull(logRecordExporter, "logRecordExporter");
        this.logProcessorInstrumentation = LogRecordProcessorInstrumentation.get(InternalTelemetryVersion.LATEST, COMPONENT_ID, meterProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        try {
            CompletableResultCode result;
            List<LogRecordData> logs = Collections.singletonList(logRecord.toLogRecordData());
            Object object = this.exporterLock;
            synchronized (object) {
                result = this.logRecordExporter.export(logs);
            }
            this.pendingExports.add(result);
            result.whenComplete(() -> {
                this.pendingExports.remove(result);
                String error = null;
                if (!result.isSuccess()) {
                    logger.log(Level.FINE, "Exporter failed");
                    error = result.getFailureThrowable() != null ? result.getFailureThrowable().getClass().getName() : "export_failed";
                }
                this.logProcessorInstrumentation.finishLogs(1, error);
            });
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Exporter threw an Exception", e);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> {
            CompletableResultCode shutdownResult = this.logRecordExporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                    result.fail();
                } else {
                    result.succeed();
                }
            });
        });
        return result;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }

    public LogRecordExporter getLogRecordExporter() {
        return this.logRecordExporter;
    }

    public String toString() {
        return "SimpleLogRecordProcessor{logRecordExporter=" + this.logRecordExporter + '}';
    }
}

