/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceFactories;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.DefaultTransactionResult;
import io.lettuce.core.protocol.RedisCommand;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class MultiOutput<K, V>
extends CommandOutput<K, V, TransactionResult> {
    private final Queue<RedisCommand<K, V, ?>> queue;
    private List<Object> responses = new ArrayList<Object>();
    private Boolean rolledBack;

    public MultiOutput(RedisCodec<K, V> codec) {
        super(codec, null);
        this.queue = LettuceFactories.newSpScQueue();
    }

    public void add(RedisCommand<K, V, ?> cmd) {
        this.queue.add(cmd);
    }

    public void cancel() {
        for (RedisCommand redisCommand : this.queue) {
            redisCommand.complete();
        }
    }

    @Override
    public void set(long integer) {
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().set(integer);
        }
    }

    @Override
    public void set(ByteBuffer bytes) {
        RedisCommand<K, V, ?> command = this.queue.peek();
        if (command != null && command.getOutput() != null) {
            command.getOutput().set(bytes);
        }
    }

    @Override
    public void multi(int count) {
        if (this.rolledBack == null) {
            this.rolledBack = count == -1;
        } else if (!this.queue.isEmpty()) {
            this.queue.peek().getOutput().multi(count);
        }
    }

    @Override
    public void setError(ByteBuffer error) {
        if (this.rolledBack == null) {
            super.setError(error);
            return;
        }
        MultiOutput output = this.queue.isEmpty() ? this : this.queue.peek().getOutput();
        output.setError(this.decodeAscii(error));
    }

    @Override
    public void complete(int depth) {
        RedisCommand<K, V, ?> cmd;
        if (this.queue.isEmpty()) {
            return;
        }
        if (depth >= 1) {
            cmd = this.queue.peek();
            cmd.getOutput().complete(depth - 1);
        }
        if (depth == 1) {
            cmd = this.queue.remove();
            CommandOutput<K, V, ?> commandOutput = cmd.getOutput();
            this.responses.add(!commandOutput.hasError() ? commandOutput.get() : new RedisCommandExecutionException(commandOutput.getError()));
            cmd.complete();
        } else if (depth == 0 && !this.queue.isEmpty()) {
            for (RedisCommand redisCommand : this.queue) {
                redisCommand.complete();
            }
        }
    }

    @Override
    public TransactionResult get() {
        return new DefaultTransactionResult(this.rolledBack == null ? false : this.rolledBack, this.responses);
    }
}

