/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import graphql.GraphQLException;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Scalars {
    public static final GraphQLNonNull RelayId = new GraphQLNonNull((GraphQLType)graphql.Scalars.GraphQLID);
    public static final GraphQLScalarType GraphQLUuid = new GraphQLScalarType("UUID", "Built-in UUID", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof String) {
                return input;
            }
            if (input instanceof UUID) {
                return input.toString();
            }
            return null;
        }

        public Object parseValue(Object input) {
            return input instanceof String ? UUID.fromString((String)input) : input;
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return UUID.fromString(((StringValue)input).getValue());
        }
    });
    public static final GraphQLScalarType GraphQLUri = new GraphQLScalarType("URI", "Built-in URI", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof URI) {
                return input.toString();
            }
            if (input instanceof String) {
                return input;
            }
            return null;
        }

        public Object parseValue(Object input) {
            return input instanceof String ? URI.create((String)input) : input;
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return URI.create(((StringValue)input).getValue());
        }
    });
    public static final GraphQLScalarType GraphQLLocale = new GraphQLScalarType("Locale", "Built-in Locale", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof Locale) {
                return ((Locale)input).toLanguageTag();
            }
            if (input instanceof String) {
                return input;
            }
            return null;
        }

        public Object parseValue(Object input) {
            return input instanceof String ? Locale.forLanguageTag((String)input) : input;
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return Locale.forLanguageTag(((StringValue)input).getValue());
        }
    });
    public static final GraphQLScalarType GraphQLDate = Scalars.temporalScalar(Date.class, s -> new Date(Instant.parse(s).toEpochMilli()), i -> new Date(i.toEpochMilli()));
    public static final GraphQLScalarType GraphQLInstant = Scalars.temporalScalar(Instant.class, Instant::parse, Function.identity());
    public static final GraphQLScalarType GraphQLLocalDate = Scalars.temporalScalar(LocalDate.class, LocalDate::parse, i -> i.atZone(ZoneOffset.UTC).toLocalDate());
    public static final GraphQLScalarType GraphQLLocalTime = Scalars.temporalScalar(LocalTime.class, LocalTime::parse, i -> i.atZone(ZoneOffset.UTC).toLocalTime());
    public static final GraphQLScalarType GraphQLLocalDateTime = Scalars.temporalScalar(LocalDateTime.class, LocalDateTime::parse, i -> i.atZone(ZoneOffset.UTC).toLocalDateTime());
    public static final GraphQLScalarType GraphQLZonedDateTime = Scalars.temporalScalar(ZonedDateTime.class, ZonedDateTime::parse, i -> i.atZone(ZoneOffset.UTC));
    public static final GraphQLScalarType GraphQLDurationScalar = Scalars.temporalScalar(Duration.class, Duration::parse, instant -> Duration.ofMillis(instant.toEpochMilli()));
    public static final GraphQLScalarType GraphQLPeriodScalar = Scalars.temporalScalar(Period.class, Period::parse, instant -> {
        throw new GraphQLException("Period can not be deserialized from a numeric value");
    });
    private static final Map<Type, GraphQLScalarType> SCALAR_MAPPING = Scalars.getScalarMapping();

    public static GraphQLScalarType graphQLObjectScalar(String name) {
        return new GraphQLScalarType(name, "Built-in object scalar", new Coercing(){

            public Object serialize(Object input) {
                return input;
            }

            public Object parseValue(Object input) {
                return input;
            }

            public Object parseLiteral(Object input) {
                if (!(input instanceof ObjectValue)) {
                    return null;
                }
                return this.parseFieldValue((Value)((ObjectValue)input));
            }

            private Object parseFieldValue(Value value) {
                if (value instanceof StringValue) {
                    return ((StringValue)value).getValue();
                }
                if (value instanceof IntValue) {
                    return ((IntValue)value).getValue();
                }
                if (value instanceof FloatValue) {
                    return ((FloatValue)value).getValue();
                }
                if (value instanceof BooleanValue) {
                    return ((BooleanValue)value).isValue();
                }
                if (value instanceof EnumValue) {
                    ((EnumValue)value).getName();
                }
                if (value instanceof ArrayValue) {
                    return ((ArrayValue)value).getValues().stream().map(this::parseFieldValue).collect(Collectors.toList());
                }
                if (value instanceof ObjectValue) {
                    return ((ObjectValue)value).getObjectFields().stream().collect(Collectors.toMap(ObjectField::getName, field -> this.parseFieldValue(field.getValue())));
                }
                throw new IllegalArgumentException("Unsupported scalar value type: " + value.getClass().getName());
            }
        });
    }

    public static <T> GraphQLScalarType temporalScalar(Class<T> type, final Function<String, T> fromString, final Function<Instant, T> fromDate) {
        return new GraphQLScalarType(type.getSimpleName(), "Built-in " + type.getSimpleName(), new Coercing(){

            public String serialize(Object input) {
                if (input == null) {
                    return null;
                }
                return input instanceof Date ? ((Date)input).toInstant().toString() : input.toString();
            }

            public Object parseValue(Object input) {
                if (input instanceof String) {
                    return fromString.apply((String)input);
                }
                if (input instanceof Long) {
                    return fromDate.apply(Instant.ofEpochMilli((Long)input));
                }
                return input;
            }

            public T parseLiteral(Object input) {
                if (input instanceof StringValue) {
                    return fromString.apply(((StringValue)input).getValue());
                }
                if (input instanceof IntValue) {
                    return fromDate.apply(Instant.ofEpochMilli(((IntValue)input).getValue().longValue()));
                }
                return null;
            }
        });
    }

    public static boolean isScalar(Type javaType) {
        return SCALAR_MAPPING.containsKey(javaType);
    }

    public static GraphQLScalarType toGraphQLScalarType(Type javaType) {
        return SCALAR_MAPPING.get(javaType);
    }

    private static Map<Type, GraphQLScalarType> getScalarMapping() {
        HashMap<Class<Object>, GraphQLScalarType> scalarMapping = new HashMap<Class<Object>, GraphQLScalarType>();
        scalarMapping.put(Character.class, graphql.Scalars.GraphQLChar);
        scalarMapping.put(Character.TYPE, graphql.Scalars.GraphQLChar);
        scalarMapping.put(String.class, graphql.Scalars.GraphQLString);
        scalarMapping.put(Byte.class, graphql.Scalars.GraphQLByte);
        scalarMapping.put(Byte.TYPE, graphql.Scalars.GraphQLByte);
        scalarMapping.put(Short.class, graphql.Scalars.GraphQLShort);
        scalarMapping.put(Short.TYPE, graphql.Scalars.GraphQLShort);
        scalarMapping.put(Integer.class, graphql.Scalars.GraphQLInt);
        scalarMapping.put(Integer.TYPE, graphql.Scalars.GraphQLInt);
        scalarMapping.put(Long.class, graphql.Scalars.GraphQLLong);
        scalarMapping.put(Long.TYPE, graphql.Scalars.GraphQLLong);
        scalarMapping.put(Float.class, graphql.Scalars.GraphQLFloat);
        scalarMapping.put(Float.TYPE, graphql.Scalars.GraphQLFloat);
        scalarMapping.put(Double.class, graphql.Scalars.GraphQLFloat);
        scalarMapping.put(Double.TYPE, graphql.Scalars.GraphQLFloat);
        scalarMapping.put(BigInteger.class, graphql.Scalars.GraphQLBigInteger);
        scalarMapping.put(BigDecimal.class, graphql.Scalars.GraphQLBigDecimal);
        scalarMapping.put(Number.class, graphql.Scalars.GraphQLBigDecimal);
        scalarMapping.put(Boolean.class, graphql.Scalars.GraphQLBoolean);
        scalarMapping.put(Boolean.TYPE, graphql.Scalars.GraphQLBoolean);
        scalarMapping.put(UUID.class, GraphQLUuid);
        scalarMapping.put(URI.class, GraphQLUri);
        scalarMapping.put(Date.class, GraphQLDate);
        scalarMapping.put(Instant.class, GraphQLInstant);
        scalarMapping.put(LocalDate.class, GraphQLLocalDate);
        scalarMapping.put(LocalTime.class, GraphQLLocalTime);
        scalarMapping.put(LocalDateTime.class, GraphQLLocalDateTime);
        scalarMapping.put(ZonedDateTime.class, GraphQLZonedDateTime);
        scalarMapping.put(Duration.class, GraphQLDurationScalar);
        scalarMapping.put(Period.class, GraphQLPeriodScalar);
        scalarMapping.put(Locale.class, GraphQLLocale);
        return Collections.unmodifiableMap(scalarMapping);
    }
}

