/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.query;

import io.hypersistence.utils.common.ReflectionUtils;
import jakarta.persistence.Query;
import java.util.function.Supplier;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.spi.InterpretationsKeySource;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SQLExtractor {
    protected SQLExtractor() {
    }

    public static String from(Query query) {
        if (query instanceof InterpretationsKeySource && query instanceof QueryImplementor) {
            SelectQueryPlan plan;
            SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey((InterpretationsKeySource)((InterpretationsKeySource)query));
            Supplier<Object> buildSelectQueryPlan = () -> ReflectionUtils.invokeMethod((Object)query, "buildSelectQueryPlan", new Object[0]);
            SelectQueryPlan selectQueryPlan = plan = cacheKey != null ? ((QueryImplementor)query).getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan((QueryInterpretationCache.Key)cacheKey, buildSelectQueryPlan) : (SelectQueryPlan)buildSelectQueryPlan.get();
            if (plan instanceof ConcreteSqmSelectQueryPlan) {
                JdbcOperation jdbcSelect;
                ConcreteSqmSelectQueryPlan selectQueryPlan2 = (ConcreteSqmSelectQueryPlan)plan;
                Object cacheableSqmInterpretation = ReflectionUtils.getFieldValueOrNull(selectQueryPlan2, "cacheableSqmInterpretation");
                if (cacheableSqmInterpretation == null) {
                    DomainQueryExecutionContext domainQueryExecutionContext = (DomainQueryExecutionContext)DomainQueryExecutionContext.class.cast(query);
                    MutableObject mutableObject = new MutableObject();
                    cacheableSqmInterpretation = ReflectionUtils.invokeStaticMethod(ReflectionUtils.getMethod(ConcreteSqmSelectQueryPlan.class, "buildInterpretation", SqmSelectStatement.class, DomainParameterXref.class, DomainQueryExecutionContext.class, MutableObject.class), ReflectionUtils.getFieldValueOrNull(selectQueryPlan2, "sqm"), ReflectionUtils.getFieldValueOrNull(selectQueryPlan2, "domainParameterXref"), domainQueryExecutionContext, mutableObject);
                }
                if (cacheableSqmInterpretation != null && (jdbcSelect = (JdbcOperation)ReflectionUtils.getFieldValueOrNull(cacheableSqmInterpretation, "jdbcOperation")) != null) {
                    return jdbcSelect.getSqlString();
                }
            }
        }
        return (String)ReflectionUtils.invokeMethod((Object)query, "getQueryString", new Object[0]);
    }
}

