/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxHandlerMethodHandler;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HtmxHandlerInterceptor
implements HandlerInterceptor {
    private final HtmxHandlerMethodHandler htmxHandlerMethodHandler;

    public HtmxHandlerInterceptor(HtmxHandlerMethodHandler htmxHandlerMethodHandler) {
        this.htmxHandlerMethodHandler = htmxHandlerMethodHandler;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.htmxHandlerMethodHandler.handleMethodArgument(request, response);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        this.setVary(request, response);
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            this.htmxHandlerMethodHandler.handleMethodAnnotations(handlerMethod.getMethod(), request, response);
        }
        return true;
    }

    private void setVary(HttpServletRequest request, HttpServletResponse response) {
        if (request.getHeader(HtmxRequestHeader.HX_REQUEST.getValue()) != null) {
            response.addHeader("Vary", HtmxRequestHeader.HX_REQUEST.getValue());
        }
    }
}

