/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.maven.MavenJDOMWriter;
import io.fabric8.maven.SortedProperties;
import io.fabric8.maven.XMLFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public final class Maven {
    private Maven() {
        throw new IllegalAccessError("Utility class");
    }

    public static Model newModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setProperties((Properties)new SortedProperties());
        return model;
    }

    public static Model readModel(String path) {
        return Maven.readModel(Paths.get(path, new String[0]));
    }

    public static Model readModel(Path pom) {
        Model model;
        block8: {
            BufferedReader br = Files.newBufferedReader(pom);
            try {
                Model model2 = Maven.readModel(br);
                model2.setPomFile(pom.toFile());
                model = model2;
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException("Error while reading pom.xml", io);
                }
            }
            br.close();
        }
        return model;
    }

    public static Model readModel(Reader rdr) {
        Model model;
        block9: {
            Reader reader = rdr;
            try {
                MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
                Model model2 = mavenXpp3Reader.read(reader);
                SortedProperties sortedProps = new SortedProperties();
                sortedProps.putAll((Map<?, ?>)model2.getProperties());
                model2.setProperties((Properties)sortedProps);
                model = model2;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException("Error while reading pom.xml", io);
                }
                catch (XmlPullParserException e) {
                    throw new RuntimeException("Error while parsing pom.xml", e);
                }
            }
            reader.close();
        }
        return model;
    }

    public static Model readModel(InputStream inputStream) {
        Model model;
        block8: {
            XmlStreamReader xmlStreamReader = ReaderFactory.newXmlReader((InputStream)inputStream);
            try {
                model = Maven.readModel((Reader)xmlStreamReader);
                if (xmlStreamReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new UncheckedIOException("Error while reading stream", io);
                }
            }
            xmlStreamReader.close();
        }
        return model;
    }

    public static void writeModel(Model model) {
        Maven.writeModel(model, model.getPomFile().toPath());
    }

    public static void writeModel(Model model, Path pom) {
        Maven.writeModel(model, pom, () -> {
            try {
                return Files.newBufferedWriter(pom, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not write to Writer", e);
            }
        });
    }

    public static void writeModel(Model model, Path pom, XMLFormat format) {
        Maven.writeModel(model, pom, () -> {
            try {
                return Files.newBufferedWriter(pom, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not write to Writer", e);
            }
        }, format);
    }

    public static void writeModel(Model model, Writer writer) {
        Maven.writeModel(model, model.getPomFile() != null ? model.getPomFile().toPath() : null, () -> writer);
    }

    public static void writeModel(Model model, Writer writer, XMLFormat format) {
        Maven.writeModel(model, model.getPomFile() != null ? model.getPomFile().toPath() : null, () -> writer, format);
    }

    public static void writeModel(Model model, Path pom, Writer writer) {
        Maven.writeModel(model, pom, () -> writer);
    }

    public static void writeModel(Model model, Path pom, Supplier<Writer> writerSupplier) {
        Maven.writeModel(model, pom, writerSupplier, null);
    }

    public static void writeModel(Model model, Path pom, Supplier<Writer> writerSupplier, XMLFormat format) {
        if (pom == null || pom.toFile().length() == 0L) {
            try (Writer writer = writerSupplier.get();){
                if (format != null) {
                    StringWriter sw = new StringWriter();
                    MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                    mavenXpp3Writer.write((Writer)sw, model);
                    format.format(new StringReader(sw.toString()), writer);
                }
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                mavenXpp3Writer.write(writer, model);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not write POM file: " + String.valueOf(pom), e);
            }
        } else {
            Document document;
            try {
                document = new SAXBuilder().build(pom.toFile());
            }
            catch (JDOMException e) {
                throw new RuntimeException("Could not parse POM file: " + String.valueOf(pom), e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not read POM file: " + String.valueOf(pom), e);
            }
            String indentation = XMLFormat.findIndentation(pom);
            try (Writer writer = writerSupplier.get();){
                MavenJDOMWriter mavenJDOMWriter = new MavenJDOMWriter(indentation);
                XMLOutputter xmlOutputter = format != null ? format.createXmlOutputter() : XMLFormat.DEFAULT.createXmlOutputter();
                mavenJDOMWriter.write(model, document, writer, xmlOutputter);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not write to Writer", e);
            }
        }
    }
}

