/*
 * #%L
 * JMexico :: Model
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Date;

public abstract class Step implements Serializable {

    private static final long serialVersionUID = 3472668071107519332L;

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_INDEX = "index";

    public static final String PROPERTY_VALUE = "value";

    public static final String PROPERTY_VALUE_TYPE = "valueType";

    public static final String PROPERTY_FEATURE = "feature";

    protected Date date;

    protected int index;

    protected Object value;

    protected ValueType valueType;

    protected Feature feature;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Date oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        int oldValue = getIndex();
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        Object oldValue = getValue();
        this.value = value;
        firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    public ValueType getValueType() {
        return valueType;
    }

    public void setValueType(ValueType valueType) {
        ValueType oldValue = getValueType();
        this.valueType = valueType;
        firePropertyChange(PROPERTY_VALUE_TYPE, oldValue, valueType);
    }

    public Feature getFeature() {
        return feature;
    }

    public void setFeature(Feature feature) {
        Feature oldValue = getFeature();
        this.feature = feature;
        firePropertyChange(PROPERTY_FEATURE, oldValue, feature);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

} //Step
