/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.rmi.coord;

import fr.inria.peerunit.Bootstrapper;
import fr.inria.peerunit.Coordinator;
import fr.inria.peerunit.Tester;
import fr.inria.peerunit.base.ResultSet;
import fr.inria.peerunit.base.Schedule;
import fr.inria.peerunit.parser.MethodDescription;
import fr.inria.peerunit.rmi.coord.MethodExecute;
import fr.inria.peerunit.test.oracle.GlobalVerdict;
import fr.inria.peerunit.util.TesterUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorImpl
implements Coordinator,
Bootstrapper,
Runnable,
Serializable {
    private static final Logger LOG = Logger.getLogger(CoordinatorImpl.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int STARTING = 0;
    private static final int IDLE = 1;
    private static final int RUNNING = 2;
    private static final int LEAVING = 3;
    private int status = 0;
    private Schedule schedule = new Schedule();
    private final List<Tester> registeredTesters;
    private final AtomicInteger expectedTesters;
    private final AtomicInteger runningTesters;
    private ExecutorService executor;
    private GlobalVerdict verdict;

    public CoordinatorImpl(int testerNbr, int relaxIndex) {
        this.expectedTesters = new AtomicInteger(testerNbr);
        this.runningTesters = new AtomicInteger(0);
        this.registeredTesters = Collections.synchronizedList(new ArrayList(testerNbr));
        this.executor = Executors.newFixedThreadPool(testerNbr > 10 ? 10 : testerNbr);
        this.verdict = new GlobalVerdict(relaxIndex);
    }

    public CoordinatorImpl(TesterUtil tu) {
        this(tu.getExpectedTesters(), tu.getRelaxIndex());
    }

    @Override
    public void registerTesters(List<Tester> testers) throws RemoteException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerMethods(Tester t, Collection<MethodDescription> list) throws RemoteException {
        assert (this.status == 0) : "Trying to register while not starting";
        LOG.entering("CoordinatorImpl", "registerMethods(Tester, Collection)");
        if (this.registeredTesters.size() >= this.expectedTesters.intValue()) {
            LOG.warning("More registrations than expected");
            return;
        }
        for (MethodDescription m : list) {
            this.schedule.put(m, t);
        }
        this.registeredTesters.add(t);
        List<Tester> list2 = this.registeredTesters;
        synchronized (list2) {
            this.registeredTesters.notifyAll();
        }
    }

    @Override
    public void run() {
        try {
            this.waitForTesterRegistration();
            this.testcaseExecution();
            this.waitAllTestersToQuit();
            this.printVerdict();
            this.cleanUp();
        }
        catch (InterruptedException ie) {
            LOG.warning(ie.getMessage());
        }
    }

    public void printVerdict() {
        System.out.println(this.verdict);
    }

    public void testcaseExecution() throws InterruptedException {
        assert (this.status == 1) : "Trying to execute test case while not idle";
        LOG.entering("CoordinatorImpl", "testCaseExecution()");
        LOG.finer(String.format("RegistredMethods: %d", this.schedule.size()));
        for (MethodDescription each : this.schedule.methods()) {
            this.execute(each);
        }
        if (!$assertionsDisabled) {
            this.status = 3;
            if (3 != 3) {
                throw new AssertionError();
            }
        }
    }

    public void execute(MethodDescription md) throws InterruptedException {
        if (!$assertionsDisabled) {
            this.status = 2;
            if (2 != 2) {
                throw new AssertionError();
            }
        }
        assert (md != null) : "Null MethodDescription";
        LOG.entering("CoordinatorImpl", "execute()", md);
        ResultSet result = new ResultSet(md);
        this.verdict.putResult(md, result);
        result.start();
        Collection<Tester> testers = this.schedule.testersFor(md);
        String message = String.format("Method %s will be executed by %d testers", md, testers.size());
        LOG.fine(message);
        this.runningTesters.set(testers.size());
        for (Tester each : testers) {
            LOG.finest("Dispatching " + md + " to tester " + each);
            this.executor.submit(new MethodExecute(each, md));
        }
        this.waitForExecutionFinished();
        result.stop();
        LOG.finest("Method " + md + " executed in " + result.getDelay() + " msec");
    }

    public ResultSet getResultFor(MethodDescription md) {
        return this.verdict.getResultFor(md);
    }

    @Override
    public synchronized int register(Tester t) throws RemoteException {
        LOG.entering("CoordinatorIml", "register(Tester)");
        int id = this.runningTesters.getAndIncrement();
        LOG.fine("New Registered Tester: " + id + " new client " + t);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void methodExecutionFinished(ResultSet rs) throws RemoteException {
        assert (rs.getMethodDescription() != null);
        assert (this.verdict.containsMethod(rs.getMethodDescription())) : "Execution finished for an unknwon method";
        ResultSet result = this.verdict.getResultFor(rs.getMethodDescription());
        result.add(rs);
        this.runningTesters.decrementAndGet();
        AtomicInteger atomicInteger = this.runningTesters;
        synchronized (atomicInteger) {
            this.runningTesters.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void quit(Tester t) throws RemoteException {
        LOG.fine(String.format("Tester %s is leaving.", t));
        List<Tester> list = this.registeredTesters;
        synchronized (list) {
            this.registeredTesters.remove(t);
            this.registeredTesters.notifyAll();
        }
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTesterRegistration() throws InterruptedException {
        assert (this.status == 0) : "Trying to register while not starting";
        LOG.fine("Waiting for registration. Expecting " + this.expectedTesters + " testers.");
        while (this.registeredTesters.size() < this.expectedTesters.intValue()) {
            List<Tester> list = this.registeredTesters;
            synchronized (list) {
                this.registeredTesters.wait();
            }
        }
        if (!$assertionsDisabled) {
            this.status = 1;
            if (1 != 1) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForExecutionFinished() throws InterruptedException {
        assert (this.status == 2) : "Trying to finish method while not running";
        LOG.fine("Waiting for the end of the execution.");
        while (this.runningTesters.intValue() > 0) {
            AtomicInteger atomicInteger = this.runningTesters;
            synchronized (atomicInteger) {
                this.runningTesters.wait();
            }
        }
        if (!$assertionsDisabled) {
            this.status = 1;
            if (1 != 1) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAllTestersToQuit() throws InterruptedException {
        LOG.fine("Waiting all testers to quit.");
        while (this.registeredTesters.size() > 0) {
            List<Tester> list = this.registeredTesters;
            synchronized (list) {
                this.registeredTesters.wait();
            }
            LOG.fine(String.format("Waiting for %d testers to quit.", this.registeredTesters.size()));
        }
        LOG.fine("All testers quit.");
    }

    public void cleanUp() {
        LOG.fine("Coordinator cleaning up.");
        this.schedule.clear();
        this.runningTesters.set(0);
        this.registeredTesters.clear();
        this.executor.shutdown();
    }

    public String toString() {
        return String.format("Coordinator(expected:%s,registered:%s,running:%s)", this.expectedTesters, new Integer(this.registeredTesters.size()), this.runningTesters);
    }

    public boolean isRoot(int id) throws RemoteException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void quit() throws RemoteException {
        throw new UnsupportedOperationException("Not supported.");
    }
}

