/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.btreeStrategy;

import fr.inria.peerunit.Coordinator;
import fr.inria.peerunit.Tester;
import fr.inria.peerunit.btreeStrategy.TreeStrategy;
import fr.inria.peerunit.util.HNode;
import fr.inria.peerunit.util.HTree;
import fr.inria.peerunit.util.TesterUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcreteBtreeStrategy
implements TreeStrategy {
    private static final Logger log = Logger.getLogger(ConcreteBtreeStrategy.class.getName());
    private TesterUtil defaults;
    private final HTree<Integer, Tester> testers;
    private final int expectedTesters;

    public ConcreteBtreeStrategy(TesterUtil tu) {
        this.defaults = tu;
        this.testers = new HTree(this.defaults.getTreeOrder());
        this.expectedTesters = this.defaults.getExpectedTesters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int register(Tester tester) throws RemoteException {
        log.entering("ConcreteBtreeStrategy", "register(Tester)");
        int id = this.testers.size();
        this.testers.put(new Integer(id), tester);
        HTree<Integer, Tester> hTree = this.testers;
        synchronized (hTree) {
            this.testers.notifyAll();
        }
        return id;
    }

    @Override
    public void buildTree() {
    }

    @Override
    public int getNodesSize() {
        return 0;
    }

    @Override
    public void setCommunication() {
        HNode<Integer, Tester> node = this.testers.head();
        this.setCommunication(node);
    }

    private void setCommunication(HNode<Integer, Tester> n) {
        assert (!n.isLeaf());
        HNode<Integer, Tester>[] children = n.children();
        ArrayList<Tester> nodes = new ArrayList<Tester>(children.length);
        for (HNode<Integer, Tester> each : children) {
            nodes.add(each.value());
        }
        try {
            log.fine(String.format("Registering %d testers to tester %d", nodes.size(), n.value().getId()));
        }
        catch (RemoteException ex) {
            Logger.getLogger(ConcreteBtreeStrategy.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Coordinator c = (Coordinator)((Object)n.value());
            c.registerTesters(nodes);
        }
        catch (RemoteException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        for (HNode<Integer, Tester> each : children) {
            if (each.isLeaf()) continue;
            this.setCommunication(each);
        }
    }

    @Override
    public int getRegistered() {
        return this.testers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTesterRegistration() throws InterruptedException {
        log.entering("ConcreteBtreeStrategy", "waitForTesterRegistration()");
        while (this.testers.size() < this.expectedTesters) {
            log.fine(String.format("Waiting for %d testers to register", this.expectedTesters - this.testers.size()));
            HTree<Integer, Tester> hTree = this.testers;
            synchronized (hTree) {
                this.testers.wait();
            }
        }
    }

    @Override
    public void startRoot() throws RemoteException {
        Tester root = this.testers.head().value();
        root.start();
    }

    @Override
    public void cleanUp() {
        this.testers.clear();
    }
}

