/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.base;

import fr.inria.peerunit.base.SingleResult;
import fr.inria.peerunit.parser.MethodDescription;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class ResultSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SingleResult> results = new LinkedList<SingleResult>();
    private final MethodDescription method;
    private int errors = 0;
    private int failures = 0;
    private int inconclusives = 0;
    private int passes = 0;
    private long accumulatedDelay = 0L;
    private long start;
    private long stop;

    public ResultSet(MethodDescription md) {
        this.method = md;
    }

    public void add(ResultSet other) {
        assert (this.method.equals(other.method)) : "Adding incompatible ResultSet";
        this.errors += other.errors;
        this.failures += other.failures;
        this.inconclusives += other.inconclusives;
        this.passes += other.passes;
        this.accumulatedDelay += other.accumulatedDelay;
        this.results.addAll(other.results);
    }

    public void add(SingleResult r) {
        assert (this.method.equals(r.getMethodDescription())) : "Adding incompatible SingleResult";
        this.results.add(r);
        this.accumulatedDelay += r.getDelay();
        switch (r.getVerdict()) {
            case PASS: {
                ++this.passes;
                break;
            }
            case ERROR: {
                ++this.errors;
                break;
            }
            case FAIL: {
                ++this.failures;
                break;
            }
            case INCONCLUSIVE: {
                ++this.inconclusives;
            }
        }
    }

    public String toString() {
        long average = this.size() == 0 ? 0L : this.accumulatedDelay / (long)this.size();
        return String.format("Step: %d. Pass: %d. Fails: %d. Erros: %d. Inconclusive: %d.  Time elapsed: %d msec. Average: %d msec. \t Method: %s", this.method.getOrder(), this.passes, this.failures, this.errors, this.inconclusives, this.getDelay(), average, this.method.getName());
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        this.stop = System.currentTimeMillis();
    }

    public long getDelay() {
        return this.stop - this.start;
    }

    public MethodDescription getMethodDescription() {
        return this.method;
    }

    public int size() {
        return this.results.size();
    }

    public int getErrors() {
        return this.errors;
    }

    public int getfailures() {
        return this.failures;
    }

    public int getInconclusives() {
        return this.inconclusives;
    }

    public int getPass() {
        return this.passes;
    }
}

