/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.KmlLoader;
import java.io.IOException;
import java.util.List;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.util.EnumSelectModel;
import org.slf4j.Logger;

@RequiresAuthentication(allowedPrograms={ObsProgram.OBSMER, ObsProgram.OBSVENTE}, allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER, UserRole.PROFESSIONAL})
public class Cartography {
    @Inject
    private Messages messages;
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private Logger logger;
    @Inject
    private PageRenderLinkSource pageRender;
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceContact serviceContact;
    private String url;
    @Property
    @Persist
    private KmlLoader.StrategyValues mapType;
    @SessionState(create=false)
    private ContactFilter cartographyFilter;
    @InjectComponent
    private Zone samplingFilterZone;
    @InjectComponent
    private Zone sampleRowFilterZone;

    void setupRender() {
        if (this.mapType == null) {
            this.mapType = KmlLoader.StrategyValues.CONTACTS_STATES;
        }
    }

    public SelectModel getMapTypeSelectModel() {
        return new EnumSelectModel(KmlLoader.StrategyValues.class, this.messages, (Enum[])KmlLoader.StrategyValues.values((ObsProgram)this.getFilter().getObsProgram()));
    }

    public ContactFilter getFilter() {
        if (this.cartographyFilter == null) {
            this.cartographyFilter = this.serviceContact.newContactFilter(this.user);
        }
        return this.cartographyFilter;
    }

    public List<Company> getCompanies() {
        List companies = this.serviceUser.getCompanies(true);
        return companies;
    }

    public List<String> getPrograms() {
        List programs = this.serviceSampling.getPrograms(this.cartographyFilter.getSamplingFilter().getCompany());
        return programs;
    }

    public List<SampleRow> getSampleRows() {
        List sampleRows = this.serviceSampling.getSampleRowsByFilter(this.cartographyFilter.getSamplingFilter());
        return sampleRows;
    }

    @Log
    Zone onValueChangedFromCompany() {
        return this.samplingFilterZone;
    }

    @Log
    Zone onValueChangedFromProgramName() {
        return this.sampleRowFilterZone;
    }

    void onSelectedFromReset() {
        this.cartographyFilter = null;
    }

    public String getUrl() throws IOException {
        if (this.url == null) {
            Link link = this.pageRender.createPageRenderLinkWithContext(KmlLoader.class, new Object[]{this.mapType});
            this.url = link.toURI();
        }
        return this.url;
    }

    public String getTitle() {
        return "Contacts";
    }
}

