/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoUtils;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.FacadeRow;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.DCF5Code;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.SampleMonth;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.components.SamplingFilterComponent;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.WaoActivationContext;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.PeriodDates;
import org.nuiton.util.StringUtil;
import org.slf4j.Logger;

@RequiresAuthentication(allowedPrograms={ObsProgram.OBSMER, ObsProgram.OBSVENTE})
@Import(stylesheet={"context:css/sampling.css"})
public class SamplingPlan {
    @Inject
    private Logger log;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private WaoManager manager;
    @Inject
    private Messages messages;
    @InjectComponent
    private SamplingFilterComponent filterComponent;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser user;
    private long nbTidesExpectedTime;
    private long nbTidesRealTime;
    private long totalTidesExpectedTime;
    private long totalTidesRealTime;
    private Map<SampleRow, Pair<Double, Long>> observationTimesInDaysPerRow;
    @Persist
    @Property
    private Boolean fullView;
    private List<SampleRow> data;
    private List<Date> months;
    @Property
    private Date month;
    @Property
    private DCF5Code dcf5code;
    private SampleRow row;
    @Property
    private String currentFacadeName;
    @Property
    private String currentSectorName;
    private static final StringUtil.ToString<FishingZone> FISHING_ZONE_TO_STRING_DISTRICT = new /* Unavailable Anonymous Inner Class!! */;
    private Map<Date, Integer> totalExpectedForMonths;
    private Map<Date, Integer> totalRealForMonths;
    private Integer highTotalExpected;
    private Integer highTotalReal;
    private Pair<Double, Long> observationTimesInDaysTotals;
    @Property
    private int rowIndex;
    @Persist
    private String selectedRowId;

    public ServiceSampling getServiceSampling() {
        return this.serviceSampling;
    }

    void setupRender() {
        if (this.fullView == null) {
            this.fullView = this.user.isAdminOrProfessional();
        }
        this.observationTimesInDaysPerRow = new HashMap();
    }

    StreamResponse onActionFromExportSamplingPlan() {
        if (this.log.isInfoEnabled()) {
            this.log.info("user " + this.user + " is asking export with " + this.getFilter());
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean isFiltersVisible() {
        return this.filterComponent.getFiltersVisible();
    }

    Object onActionFromShowFilters() {
        this.filterComponent.switchFiltersVisible();
        return this.filterComponent;
    }

    public PeriodDates getPeriod() {
        return this.getFilter().getPeriod();
    }

    public SamplingFilter getFilter() {
        return (SamplingFilter)this.filterComponent.getFilter();
    }

    void onActionFromToggleDisplayMode() {
        this.fullView = this.fullView == false;
    }

    void onActionFromChangeFilterEstimatedTides() {
        boolean oldValue = this.getFilter().getEstimatedTides();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Change estimatedTides in filter to : " + !oldValue);
        }
        this.getFilter().setEstimatedTides(!oldValue);
    }

    public String getDcf5CodeDescription() {
        String description = this.dcf5code.getFishingGearCode() + " - " + this.dcf5code.getFishingGearDescription();
        if (this.dcf5code.getTargetSpeciesCode() != null) {
            description = description + " ; " + this.dcf5code.getTargetSpeciesCode() + " - " + this.dcf5code.getTargetSpeciesDescription();
        }
        return description;
    }

    public SampleRow getRow() {
        return this.row;
    }

    public void setRow(SampleRow row) {
        if (this.row != row) {
            this.row = row;
        }
    }

    public List<SampleRow> getData() throws WaoException {
        if (this.data == null) {
            FacadeRow facade = this.serviceSampling.getSampleRowsOrderedByFishingZone(this.getFilter());
            this.data = facade.getValues();
        }
        return this.data;
    }

    public List<Date> getMonths() {
        if (this.months == null) {
            this.months = this.getPeriod().getMonths();
        }
        return this.months;
    }

    @Log
    public boolean isFacadeChanged() {
        boolean facadeChanged = false;
        if (!this.row.getFacade().equals(this.currentFacadeName)) {
            this.currentFacadeName = this.row.getFacade();
            facadeChanged = true;
        }
        if (facadeChanged) {
            this.currentSectorName = null;
        }
        return facadeChanged;
    }

    @Log
    public boolean isSectorChanged() {
        boolean sectorChanged = false;
        if (!this.row.getSectors().equals(this.currentSectorName)) {
            this.currentSectorName = this.row.getSectors();
            sectorChanged = true;
        }
        return sectorChanged;
    }

    public String getCompanyName() {
        return this.row.getCompany() != null ? this.row.getCompany().getName() : "";
    }

    public boolean isCurrentMonth() {
        String currentStr = this.getDateFormat().format(new Date());
        String monthStr = this.getDateFormat().format(this.month);
        return currentStr.equals(monthStr);
    }

    public Integer getNbTidesExpected() {
        Integer result = null;
        SampleMonth sampleMonth = this.row.getSampleMonth(this.month);
        if (sampleMonth != null) {
            result = sampleMonth.getExpectedTidesValue();
        }
        return result;
    }

    public String getFishingZones() {
        return StringUtil.join((Iterable)this.row.getFishingZone(), (StringUtil.ToString)FISHING_ZONE_TO_STRING_DISTRICT, (String)", ", (boolean)false);
    }

    public Integer getNbTidesReal() {
        Integer result = null;
        SampleMonth sampleMonth = this.row.getSampleMonth(this.month);
        if (sampleMonth != null) {
            result = this.getFilter().getEstimatedTides() ? sampleMonth.getEstimatedTidesValue() : sampleMonth.getRealTidesValue();
        }
        return result;
    }

    public boolean hasNbTidesReal() {
        Date current = new Date();
        boolean validMonth = this.month.before(current) || this.isCurrentMonth();
        return validMonth && this.getNbTidesReal() != null;
    }

    public boolean canDisplayTidesReal() {
        boolean result = this.hasNbTidesReal() && !this.user.isGuest();
        return result;
    }

    public String getTotalPercentage() {
        String result;
        if (this.row.getTotalTidesExpected() > 0) {
            double percentage = (double)this.row.getTotalTidesReal().intValue() / (double)this.row.getTotalTidesExpected().intValue();
            result = NumberFormat.getPercentInstance().format(percentage);
        } else {
            result = "- %";
        }
        return result;
    }

    public NumberFormat getNumberFormat() {
        return NumberFormat.getNumberInstance();
    }

    public NumberFormat getPercentFormat() {
        return NumberFormat.getPercentInstance();
    }

    protected void setTotalsForMonths() {
        Date keptMonth = this.month;
        this.totalExpectedForMonths = new HashMap();
        this.totalRealForMonths = new HashMap();
        this.highTotalExpected = 0;
        this.highTotalReal = 0;
        Iterator<Object> i$ = this.getMonths().iterator();
        while (i$.hasNext()) {
            Date date;
            this.month = date = (Date)i$.next();
            Integer totalExpected = null;
            Integer totalReal = null;
            Iterator i$2 = this.getData().iterator();
            while (i$2.hasNext()) {
                SampleRow row;
                this.row = row = (SampleRow)i$2.next();
                Integer expected = this.getNbTidesExpected();
                Integer real = this.getNbTidesReal();
                if (this.log.isTraceEnabled()) {
                    this.log.trace(String.format("for month %s and row %s : expected = %s, real = %s", this.getDateFormat().format(date), row.getCode(), expected, real));
                }
                if (expected != null) {
                    if (totalExpected == null) {
                        totalExpected = 0;
                    }
                    totalExpected = totalExpected + expected;
                }
                if (real == null || !this.canDisplayTidesReal()) continue;
                if (totalReal == null) {
                    totalReal = 0;
                }
                totalReal = totalReal + real;
            }
            this.totalExpectedForMonths.put(date, totalExpected);
            this.totalRealForMonths.put(date, totalReal);
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("totals for month %s : expected = %s, actual = %s", this.getDateFormat().format(date), totalExpected, totalReal));
            }
            if (totalExpected != null) {
                this.highTotalExpected = this.highTotalExpected + totalExpected;
            }
            if (totalReal == null) continue;
            this.highTotalReal = this.highTotalReal + totalReal;
        }
        if (this.log.isDebugEnabled()) {
            for (Map.Entry entry : this.totalExpectedForMonths.entrySet()) {
                this.log.debug(String.format("totals for month %s : expected = %s, actual = %s", this.getDateFormat().format((Date)entry.getKey()), entry.getValue(), this.totalRealForMonths.get(entry.getKey())));
            }
        }
        this.month = keptMonth;
    }

    public Integer getTotalExpectedForMonth() {
        if (this.totalExpectedForMonths == null) {
            this.setTotalsForMonths();
        }
        Integer total = (Integer)this.totalExpectedForMonths.get(this.month);
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("total for month %s is %s", this.getDateFormat().format(this.month), total));
        }
        return total;
    }

    public Integer getTotalRealForMonth() {
        if (this.totalExpectedForMonths == null) {
            this.setTotalsForMonths();
        }
        return (Integer)this.totalRealForMonths.get(this.month);
    }

    public String getRatioForMonth() {
        String ratio = "-";
        if (this.getTotalExpectedForMonth() != null && this.getTotalRealForMonth() != null && this.getTotalExpectedForMonth() > 0 && this.getTotalRealForMonth() > 0) {
            double percent = (double)this.getTotalRealForMonth().intValue() / (double)this.getTotalExpectedForMonth().intValue();
            ratio = NumberFormat.getPercentInstance().format(percent);
        }
        return ratio;
    }

    public Integer getHighTotalExpected() {
        if (this.highTotalExpected == null) {
            this.setTotalsForMonths();
        }
        return this.highTotalExpected;
    }

    public Integer getHighTotalReal() {
        if (this.highTotalReal == null) {
            this.setTotalsForMonths();
        }
        return this.highTotalReal;
    }

    public String getHighTotalRatio() {
        String ratio = "";
        if (this.getHighTotalExpected() > 0) {
            double percent = (double)this.getHighTotalReal().intValue() / (double)this.getHighTotalExpected().intValue();
            ratio = NumberFormat.getPercentInstance().format(percent);
        }
        return ratio;
    }

    public Pair<Double, Long> getObservationTimesInDaysForRow() {
        Pair observationTimesInDaysForRow = (Pair)this.observationTimesInDaysPerRow.get(this.row);
        if (observationTimesInDaysForRow == null) {
            observationTimesInDaysForRow = this.serviceSampling.getObservationTimesInDays(this.row, this.getFilter().isEstimatedTides());
            this.observationTimesInDaysPerRow.put(this.row, observationTimesInDaysForRow);
        }
        return observationTimesInDaysForRow;
    }

    public Double getObservationTimesInDaysForRowLeft() {
        return (Double)this.getObservationTimesInDaysForRow().getLeft();
    }

    public Long getObservationTimesInDaysForRowRight() {
        return (Long)this.getObservationTimesInDaysForRow().getRight();
    }

    public String getRealTidesClassForObservationTimesInDays() {
        String result = "real-warning";
        if (this.getObservationTimesInDaysForRowLeft() > (double)this.getObservationTimesInDaysForRowRight().longValue()) {
            result = result + "-inf";
        } else if (this.getObservationTimesInDaysForRowLeft() < (double)this.getObservationTimesInDaysForRowRight().longValue()) {
            result = result + "-sup";
        }
        return result;
    }

    public Pair<Double, Long> getObservationTimesInDaysTotals() {
        if (this.observationTimesInDaysTotals == null) {
            double totalPlanned = 0.0;
            long totalActual = 0L;
            for (Pair plannedActual : this.observationTimesInDaysPerRow.values()) {
                totalPlanned += ((Double)plannedActual.getLeft()).doubleValue();
                totalActual += ((Long)plannedActual.getRight()).longValue();
            }
            this.observationTimesInDaysTotals = Pair.of((Object)totalPlanned, (Object)totalActual);
        }
        return this.observationTimesInDaysTotals;
    }

    public Double getObservationTimesInDaysTotalPlanned() {
        return (Double)this.getObservationTimesInDaysTotals().getLeft();
    }

    public Long getObservationTimesInDaysTotalActual() {
        return (Long)this.getObservationTimesInDaysTotals().getRight();
    }

    public String getRealTidesClassForObservationTimesInDaysTotalActual() {
        String result = "real-warning";
        if (this.getObservationTimesInDaysTotalPlanned() > (double)this.getObservationTimesInDaysTotalActual().longValue()) {
            result = result + "-inf";
        } else if (this.getObservationTimesInDaysTotalPlanned() < (double)this.getObservationTimesInDaysTotalActual().longValue()) {
            result = result + "-sup";
        }
        return result;
    }

    public String getRowComment() {
        String rowComment = null;
        if (this.row.getComment() != null) {
            rowComment = this.row.getComment();
            rowComment = WaoUtils.escapeForToolTip((String)rowComment);
        }
        return rowComment;
    }

    public int getNbColumnsForProfession() {
        int fixed = 5;
        if (this.fullView.booleanValue()) {
            fixed += 8;
        }
        if (this.user.isObsVente()) {
            fixed += 3;
        }
        return fixed;
    }

    public int getNbColumnsForMonths() {
        return this.getMonths().size() + 1;
    }

    public int getNbColumnsForOther() {
        int nbColumnsForOther = 2;
        if (this.user.isObsMer()) {
            nbColumnsForOther += 4;
        }
        return nbColumnsForOther;
    }

    public int getNbColumnsTotal() {
        int nbColumnsTotal = this.getNbColumnsForProfession() + this.getNbColumnsForMonths() + this.getNbColumnsForOther();
        if (this.user.isObsMer()) {
            ++nbColumnsTotal;
        }
        return nbColumnsTotal;
    }

    public String getMainClass() {
        return this.fullView != false ? "admin" : "user";
    }

    public String getRealTidesClass() {
        String result = "real-warning";
        if (this.getNbTidesReal() < this.getNbTidesExpected()) {
            result = result + "-inf";
        } else if (this.getNbTidesReal() > this.getNbTidesExpected()) {
            result = result + "-sup";
        }
        return result;
    }

    public String getRealTidesClassForTotal() {
        String result = "real-warning";
        if (this.getTotalRealForMonth() != null && this.getTotalExpectedForMonth() != null) {
            if (this.getTotalRealForMonth() < this.getTotalExpectedForMonth()) {
                result = result + "-inf";
            } else if (this.getTotalExpectedForMonth() > this.getTotalRealForMonth()) {
                result = result + "-sup";
            }
        }
        return result;
    }

    public String getMonthCurrentClass() {
        return this.isCurrentMonth() ? "selected" : "";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    public void setSelectedRowId(String selectedRowId) {
        this.selectedRowId = selectedRowId;
    }

    public String getRowClasses() {
        String classes;
        String string = classes = this.rowIndex % 2 == 0 ? "even" : "odd";
        if (this.row.getTopiaId().equals(this.selectedRowId)) {
            classes = classes + " selected";
        }
        return classes;
    }

    public boolean canEditSampleRow() {
        return this.user.isAdmin() && !this.user.isReadOnly();
    }

    void onActionFromFilterPeriodDates(int rowIndex) throws WaoException {
        this.row = (SampleRow)this.getData().get(rowIndex);
        this.getPeriod().setFromDate(this.row.getPeriodBegin());
        this.getPeriod().setThruDate(this.row.getPeriodEnd());
    }

    void onActionFromDeleteSampleRow(int rowIndex) throws WaoException {
        this.row = (SampleRow)this.getData().get(rowIndex);
        try {
            this.serviceSampling.deleteSampleRow(this.row);
        }
        catch (WaoBusinessException eee) {
            String error = this.manager.getErrorMessage(eee, this.messages, this.log);
            this.layout.addError(new String[]{error});
        }
    }

    public boolean isRowNotFinished() {
        return !this.row.isFinished(-1);
    }

    public boolean isRowModified() {
        boolean rowHasHistoric = CollectionUtils.isNotEmpty((Collection)this.row.getSampleRowLog());
        return rowHasHistoric;
    }

    public String[] getContextForEditingSampleRow() {
        WaoActivationContext waoActivationContext = WaoActivationContext.newEmptyContext();
        waoActivationContext.setSampleRowId(this.row.getTopiaId());
        return waoActivationContext.toStrings();
    }

    public String[] getContextForBoats() {
        WaoActivationContext contextForBoats = WaoActivationContext.newEmptyContext();
        contextForBoats.setSampleRowCode(this.row.getCode());
        return contextForBoats.toStrings();
    }

    static /* synthetic */ ConnectedUser access$000(SamplingPlan x0) {
        return x0.user;
    }

    static /* synthetic */ ServiceSampling access$100(SamplingPlan x0) {
        return x0.serviceSampling;
    }
}

