/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataTableCell;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.MoveToNextEditableCellAction;
import org.nuiton.jaxx.application.swing.table.MoveToNextEditableRowAction;
import org.nuiton.jaxx.application.swing.table.MoveToPreviousEditableCellAction;
import org.nuiton.jaxx.application.swing.table.MoveToPreviousEditableRowAction;

public abstract class AbstractTuttiTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiTableUIModel<?, R, M>, UI extends TuttiUI<M, ?>>
extends AbstractTuttiUIHandler<M, UI> {
    private static final Log log = LogFactory.getLog(AbstractTuttiTableUIHandler.class);
    private final TuttiBeanMonitor<R> rowMonitor;
    private ListSelectionListener tableSelectionListener;
    private Map<JTable, KeyAdapter> keyAdapters = new HashMap<JTable, KeyAdapter>();

    public abstract AbstractApplicationTableModel<R> getTableModel();

    public abstract JXTable getTable();

    protected abstract boolean isRowValid(R var1);

    protected void onRowModified(int rowIndex, R row, String propertyName, Object oldValue, Object newValue) {
        ((AbstractTuttiTableUIModel)this.getModel()).setModify(true);
    }

    protected abstract void saveSelectedRowIfRequired(TuttiBeanMonitor<R> var1, R var2);

    protected AbstractTuttiTableUIHandler(String ... properties) {
        this.rowMonitor = new TuttiBeanMonitor(properties);
        this.rowMonitor.addPropertyChangeListener("bean", new PropertyChangeListener(){
            final Set<String> propertiesToSkip;
            final PropertyChangeListener l;
            {
                this.propertiesToSkip = Sets.newHashSet((Object[])AbstractTuttiTableUIHandler.this.getRowPropertiesToIgnore());
                this.l = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        String propertyName = evt.getPropertyName();
                        AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)evt.getSource();
                        Object oldValue = evt.getOldValue();
                        Object newValue = evt.getNewValue();
                        int rowIndex = AbstractTuttiTableUIHandler.this.getTableModel().getRowIndex((Serializable)row);
                        if ("valid".equals(propertyName)) {
                            AbstractTuttiTableUIHandler.this.onRowValidStateChanged(rowIndex, row, (Boolean)oldValue, (Boolean)newValue);
                        } else if ("modify".equals(propertyName)) {
                            AbstractTuttiTableUIHandler.this.onRowModifyStateChanged(rowIndex, row, (Boolean)oldValue, (Boolean)newValue);
                        } else if (!propertiesToSkip.contains(propertyName)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("row [" + rowIndex + "] property " + propertyName + " changed from " + oldValue + " to " + newValue));
                            }
                            AbstractTuttiTableUIHandler.this.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
                        }
                    }
                };
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTuttiBeanUIModel oldValue = (AbstractTuttiBeanUIModel)evt.getOldValue();
                AbstractTuttiBeanUIModel newValue = (AbstractTuttiBeanUIModel)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Monitor row changed from " + oldValue + " to " + newValue));
                }
                if (oldValue != null) {
                    oldValue.removePropertyChangeListener(this.l);
                }
                if (newValue != null) {
                    newValue.addPropertyChangeListener(this.l);
                }
            }
        });
    }

    protected String[] getRowPropertiesToIgnore() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    protected void onModelRowsChanged(List<R> rows) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will set " + (rows == null ? 0 : rows.size()) + " rows on model."));
        }
        if (CollectionUtils.isNotEmpty(rows)) {
            for (AbstractTuttiBeanUIModel row : rows) {
                this.recomputeRowValidState(row);
            }
        }
        this.getTableModel().setRows(rows);
    }

    protected void onRowModifyStateChanged(int rowIndex, R row, Boolean oldValue, Boolean newValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("row [" + rowIndex + "] modify state changed from " + oldValue + " to " + newValue));
        }
    }

    protected void onRowValidStateChanged(int rowIndex, R row, Boolean oldValue, Boolean newValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("row [" + rowIndex + "] valid state changed from " + oldValue + " to " + newValue));
        }
        if (rowIndex > -1) {
            this.getTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    protected void onAfterSelectedRowChanged(int oldRowIndex, R oldRow, int newRowIndex, R newRow) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected row changed from [" + oldRowIndex + "] to [" + newRowIndex + "]"));
        }
    }

    protected void initTable(JXTable table) {
        table.getTableHeader().setReorderingAllowed(false);
        this.addHighlighters(table);
        ((AbstractTuttiTableUIModel)this.getModel()).addPropertyChangeListener("rows", evt -> this.onModelRowsChanged((List)evt.getNewValue()));
        SwingUtil.scrollToTableSelection((JTable)this.getTable());
        this.uninstallTableSaveOnRowChangedSelectionListener();
        this.installTableSaveOnRowChangedSelectionListener();
    }

    protected void installTableSaveOnRowChangedSelectionListener() {
        Preconditions.checkState((this.tableSelectionListener == null ? 1 : 0) != 0, (Object)"There is already a tableSelectionListener registred, remove it before invoking this method.");
        this.tableSelectionListener = new ListSelectionListener(){
            protected int selectedRowIndex;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Selection changed: " + e));
                }
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                int oldRowIndex = this.selectedRowIndex;
                int newRowIndex = source.getLeadSelectionIndex();
                AbstractTuttiBeanUIModel oldRow = (AbstractTuttiBeanUIModel)AbstractTuttiTableUIHandler.this.rowMonitor.getBean();
                if (oldRow == null || oldRowIndex != newRowIndex) {
                    AbstractTuttiBeanUIModel newRow = source.isSelectionEmpty() ? null : (AbstractTuttiBeanUIModel)AbstractTuttiTableUIHandler.this.getTableModel().getEntry(newRowIndex);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Will monitor entry: " + newRowIndex));
                    }
                    AbstractTuttiTableUIHandler.this.rowMonitor.setBean(newRow);
                    this.selectedRowIndex = newRowIndex;
                    AbstractTuttiTableUIHandler.this.onAfterSelectedRowChanged(oldRowIndex, oldRow, this.selectedRowIndex, (AbstractTuttiBeanUIModel)AbstractTuttiTableUIHandler.this.rowMonitor.getBean());
                }
            }
        };
        if (log.isDebugEnabled()) {
            log.debug((Object)("Intall " + this.tableSelectionListener + " on tableModel " + this.getTableModel()));
        }
        this.getTable().getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    protected void uninstallTableSaveOnRowChangedSelectionListener() {
        if (this.tableSelectionListener != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Desintall " + this.tableSelectionListener));
            }
            this.getTable().getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
            this.tableSelectionListener = null;
        }
    }

    protected void installTableKeyListener(TableColumnModel columnModel, JTable table) {
        this.installTableKeyListener(columnModel, table, true);
    }

    protected void installTableKeyListener(TableColumnModel columnModel, final JTable table, final boolean enterToChangeRow) {
        Preconditions.checkState((this.keyAdapters.get(table) == null ? 1 : 0) != 0, (Object)"There is already a tableSelectionListener registred, remove it before invoking this method.");
        AbstractApplicationTableModel model = (AbstractApplicationTableModel)table.getModel();
        final MoveToNextEditableCellAction nextCellAction = MoveToNextEditableCellAction.newAction((AbstractApplicationTableModel)model, (JTable)table);
        final MoveToPreviousEditableCellAction previousCellAction = MoveToPreviousEditableCellAction.newAction((AbstractApplicationTableModel)model, (JTable)table);
        final MoveToNextEditableRowAction nextRowAction = MoveToNextEditableRowAction.newAction((AbstractApplicationTableModel)model, (JTable)table);
        final MoveToPreviousEditableRowAction previousRowAction = MoveToPreviousEditableRowAction.newAction((AbstractApplicationTableModel)model, (JTable)table);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean shiftDown;
                TableCellEditor editor = table.getCellEditor();
                int keyCode = e.getKeyCode();
                if (this.gotoPreviousCell(keyCode, shiftDown = e.isShiftDown())) {
                    this.consumeAction(e, editor, (AbstractAction)previousCellAction);
                } else if (this.gotoNextCell(keyCode)) {
                    this.consumeAction(e, editor, (AbstractAction)nextCellAction);
                } else if (this.gotoPreviousRow(keyCode, shiftDown)) {
                    this.consumeAction(e, editor, (AbstractAction)previousRowAction);
                } else if (this.gotoNextRow(keyCode)) {
                    this.consumeAction(e, editor, (AbstractAction)nextRowAction);
                }
            }

            protected void consumeAction(KeyEvent e, TableCellEditor editor, AbstractAction action) {
                e.consume();
                if (editor != null) {
                    editor.stopCellEditing();
                }
                action.actionPerformed(null);
            }

            protected boolean gotoPreviousCell(int keyCode, boolean shiftDown) {
                return keyCode == 37 || keyCode == 9 && shiftDown || !enterToChangeRow && keyCode == 10 && shiftDown;
            }

            protected boolean gotoNextCell(int keyCode) {
                return keyCode == 39 || keyCode == 9 || !enterToChangeRow && keyCode == 10;
            }

            protected boolean gotoPreviousRow(int keyCode, boolean shiftDown) {
                return keyCode == 38 || enterToChangeRow && keyCode == 10 && shiftDown;
            }

            protected boolean gotoNextRow(int keyCode) {
                return keyCode == 40 || enterToChangeRow && keyCode == 10;
            }
        };
        this.keyAdapters.put(table, keyAdapter);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Intall " + keyAdapter));
        }
        table.addKeyListener(keyAdapter);
        Enumeration<TableColumn> columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            Object editor;
            TableColumn tableColumn = columns.nextElement();
            TableCellEditor cellEditor = tableColumn.getCellEditor();
            if (cellEditor instanceof NumberCellEditor) {
                editor = (NumberCellEditor)cellEditor;
                editor.getNumberEditor().getTextField().addKeyListener(keyAdapter);
                continue;
            }
            if (cellEditor instanceof ComputableDataTableCell.TuttiComputedOrNotDataTableCellEditor) {
                editor = (ComputableDataTableCell.TuttiComputedOrNotDataTableCellEditor)cellEditor;
                ((ComputableDataTableCell.TuttiComputedOrNotDataTableCellEditor)editor).getNumberEditor().getTextField().addKeyListener(keyAdapter);
                continue;
            }
            if (!(cellEditor instanceof SampleCategoryComponent.SampleCategoryEditor)) continue;
            editor = (SampleCategoryComponent.SampleCategoryEditor)cellEditor;
            ((SampleCategoryComponent.SampleCategoryEditor)editor).getNumberEditor().getTextField().addKeyListener(keyAdapter);
        }
    }

    protected void uninstallTableKeyListener(JTable table) {
        KeyAdapter keyAdapter = this.keyAdapters.get(table);
        if (keyAdapter != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Desintall " + keyAdapter));
            }
            table.removeKeyListener(keyAdapter);
            TableColumnModel columnModel = table.getColumnModel();
            Enumeration<TableColumn> columns = columnModel.getColumns();
            while (columns.hasMoreElements()) {
                TableColumn tableColumn = columns.nextElement();
                TableCellEditor cellEditor = tableColumn.getCellEditor();
                if (!(cellEditor instanceof NumberCellEditor)) continue;
                NumberCellEditor editor = (NumberCellEditor)cellEditor;
                editor.getNumberEditor().getTextField().removeKeyListener(keyAdapter);
            }
            this.keyAdapters.remove(table);
        }
    }

    protected final void saveSelectedRowIfNeeded() {
        AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)this.rowMonitor.getBean();
        if (row != null) {
            this.saveSelectedRowIfRequired(this.rowMonitor, row);
        }
    }

    protected void cleanrRowMonitor() {
        this.rowMonitor.clearModified();
    }

    protected final void recomputeRowValidState(R row) {
        boolean valid = this.isRowValid(row);
        ((AbstractTuttiBeanUIModel)row).setValid(valid);
        if (valid) {
            ((AbstractTuttiTableUIModel)this.getModel()).removeRowInError(row);
        } else {
            ((AbstractTuttiTableUIModel)this.getModel()).addRowInError(row);
        }
    }
}

