/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.query.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.synchro.query.SynchroQueryBuilder;
import fr.ifremer.adagio.synchro.query.SynchroQueryName;
import fr.ifremer.adagio.synchro.query.internal.SynchroAbstractQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class SynchroInsertQuery
extends SynchroAbstractQuery {
    protected Map<String, String> columnValues;

    public SynchroInsertQuery(SynchroQueryName queryName, String tableName, List<String> columnNames) {
        super(queryName, tableName, columnNames, false);
        this.columnValues = Maps.newHashMap();
    }

    public SynchroInsertQuery(SynchroQueryName queryName, String tableName, List<String> columnNames, List<String> columnValues) {
        super(queryName, tableName, columnNames, false);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnValues));
        Preconditions.checkArgument((columnNames.size() == columnValues.size() ? 1 : 0) != 0);
        this.columnValues = Maps.newHashMap();
        int i = 0;
        for (String columnValue : columnValues) {
            String columnName = columnNames.get(i++).toLowerCase();
            this.columnValues.put(columnName, columnValue);
        }
    }

    public SynchroInsertQuery(SynchroQueryName queryName, String tableName) {
        super(queryName, tableName, false);
        this.columnValues = Maps.newHashMap();
    }

    @Override
    public SynchroQueryBuilder addColumn(String columnName, String value) {
        super.addColumn(columnName, value);
        this.columnValues.put(columnName.toLowerCase(), value);
        return this;
    }

    @Override
    public SynchroQueryBuilder setColumnValue(String columnName, String value) {
        Preconditions.checkArgument((boolean)this.columnNames.contains(columnName));
        this.columnValues.put(columnName, value);
        return this;
    }

    @Override
    public String getColumnValue(String columnName) {
        return this.columnValues.get(columnName);
    }

    @Override
    public SynchroQueryBuilder deleteColumn(String columnName) {
        super.deleteColumn(columnName);
        this.columnValues.remove(columnName.toLowerCase());
        return this;
    }

    @Override
    public SynchroQueryBuilder deleteColumnIfExists(String columnName) {
        super.deleteColumnIfExists(columnName);
        this.columnValues.remove(columnName.toLowerCase());
        return this;
    }

    @Override
    public boolean constainsColumn(String columnName) {
        return this.columnNames.contains(columnName);
    }

    public List<String> getBindingColumnNames() {
        ArrayList result = Lists.newArrayList();
        for (String columnName : this.columnNames) {
            String columnValue = this.columnValues.get(columnName);
            if (!"?".equals(columnValue) && !columnValue.startsWith(":")) continue;
            result.add(columnName);
        }
        return ImmutableList.copyOf((Collection)result);
    }

    @Override
    public String toSql() {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)this.columnNames));
        StringBuilder queryParams = new StringBuilder();
        StringBuilder valueParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            queryParams.append(", ").append(columnName);
            String value = this.columnValues.get(columnName);
            if (value != null) {
                valueParams.append(", ").append(value);
                continue;
            }
            valueParams.append(", ?");
        }
        String sql = String.format("INSERT INTO %s (%s) VALUES (%s)", this.tableName, queryParams.substring(2), valueParams.substring(2));
        return sql;
    }
}

