/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.util.ArrayList;

public class DiagonalLineInfo {
    private static final double CELL_MARGIN_COMPENSATION = 5.4;
    private int diagonalCount = -1;
    private String diagonalStyle = null;
    private int diagonalWidth = 0;
    private int antiDiagonalCount = -1;
    private String antiDiagonalStyle = null;
    private int antiDiagonalWidth = 0;
    private String color = null;
    private static final double DEFAULT_COORDSIZEX = 100.0;
    private static final double DEFAULT_COORDSIZEY = 100.0;
    private double width = 100.0;
    private double height = 100.0;
    private double coordoriginX = 0.0;
    private double coordoriginY = 0.0;

    public void setDiagonalLine(int diagonalCount, String diagonalStyle, int diagonalWidth) {
        this.diagonalCount = diagonalCount > 3 ? 3 : diagonalCount;
        this.diagonalStyle = diagonalStyle;
        this.diagonalWidth = diagonalWidth;
    }

    public void setAntidiagonalLine(int antidiagonalCount, String antidiagonalStyle, int antidiagonalWidth) {
        this.antiDiagonalCount = antidiagonalCount;
        this.antiDiagonalStyle = antidiagonalStyle;
        this.antiDiagonalWidth = antidiagonalWidth;
    }

    public void setCoordinateSize(double coordinateSizeX, double coordinateSizeY) {
        if (coordinateSizeX != 0.0) {
            this.width = coordinateSizeX;
        }
        if (coordinateSizeY != 0.0) {
            this.height = coordinateSizeY;
        }
    }

    public void setCoordinateOrigin(int coordinateOriginX, int coordinateOriginY) {
        this.coordoriginX = coordinateOriginX;
        this.coordoriginY = coordinateOriginY;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public ArrayList<Line> getDiagonalLine() {
        ArrayList<Line> diagonalLine = new ArrayList<Line>();
        int num = this.diagonalCount >> 1;
        double x = 2.0 / (double)(this.diagonalCount + 1) * this.width;
        double y = 2.0 / (double)(this.diagonalCount + 1) * this.height;
        if ((this.diagonalCount & 1) == 1) {
            diagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY, this.coordoriginX + this.width - 5.4, this.coordoriginY + this.height));
        }
        int i = 1;
        while (i <= num) {
            diagonalLine.add(new Line(this.coordoriginX + this.width - (double)i * x - 5.4, this.coordoriginY, this.coordoriginX + this.width - 5.4, this.coordoriginY + this.height));
            diagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY + this.height - (double)i * y, this.coordoriginX + this.width - 5.4, this.coordoriginY + this.height));
            ++i;
        }
        return diagonalLine;
    }

    public ArrayList<Line> getAntidiagonalLine() {
        ArrayList<Line> antiDiagonalLine = new ArrayList<Line>();
        int num = this.antiDiagonalCount >> 1;
        double x = 2.0 / (double)(this.antiDiagonalCount + 1) * this.width;
        double y = 2.0 / (double)(this.antiDiagonalCount + 1) * this.height;
        if ((this.antiDiagonalCount & 1) == 1) {
            antiDiagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY + this.height, this.coordoriginX + this.width - 5.4, this.coordoriginY));
        }
        int i = 1;
        while (i <= num) {
            antiDiagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY + this.height, this.coordoriginX + (double)i * x - 5.4, this.coordoriginY));
            antiDiagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY + this.height, this.coordoriginX + this.width - 5.4, this.coordoriginY + this.height - (double)i * y));
            ++i;
        }
        return antiDiagonalLine;
    }

    public int getDiagonalNumber() {
        return this.diagonalCount;
    }

    public int getAntiDiagonalNumber() {
        return this.antiDiagonalCount;
    }

    public String getDiagonalStyle() {
        return this.diagonalStyle;
    }

    public String getAntiDiagonalStyle() {
        return this.antiDiagonalStyle;
    }

    public double getDiagonalLineWidth() {
        return this.diagonalWidth;
    }

    public double getAntiDiagonalLineWidth() {
        return this.antiDiagonalWidth;
    }

    public static class Line {
        double xCoordinateFrom;
        double yCoordinateFrom;
        double xCoordinateTo;
        double yCoordinateTo;

        Line(double xFrom, double yFrom, double xTo, double yTo) {
            this.xCoordinateFrom = xFrom;
            this.yCoordinateFrom = yFrom;
            this.xCoordinateTo = xTo;
            this.yCoordinateTo = yTo;
        }

        public double getXCoordinateFrom() {
            return this.xCoordinateFrom;
        }

        public double getYCoordinateFrom() {
            return this.yCoordinateFrom;
        }

        public double getXCoordinateTo() {
            return this.xCoordinateTo;
        }

        public double getYCoordinateTo() {
            return this.yCoordinateTo;
        }
    }
}

