/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise.actions;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.cruise.GearCaracteristicsEditorUI;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewGearCaracteristicsAction
extends LongActionSupport<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ViewGearCaracteristicsAction.class);
    protected final PersistenceService persistenceService = this.getContext().getPersistenceService();

    public ViewGearCaracteristicsAction(EditCruiseUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        GearCaracteristicsEditorUI editor = ((EditCruiseUI)this.getUI()).getGearCaracteristicsEditor();
        editor.getModel().setEditable(false);
        GearWithOriginalRankOrder gear = (GearWithOriginalRankOrder)EditCruiseUIHandler.GEAR_EDIT_CONTEXT.getContextValue((JAXXContext)this.getUI());
        CaracteristicMap caracteristics = this.persistenceService.getGearCaracteristics(this.getDataContext().getCruise().getIdAsInt(), gear.getIdAsInt(), gear.getOriginalRankOrder().shortValue());
        GearWithOriginalRankOrder gearToEdit = GearWithOriginalRankOrders.newGearWithOriginalRankOrder((GearWithOriginalRankOrder)gear);
        gearToEdit.setCaracteristics(caracteristics);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will edit gear " + this.decorate(gearToEdit) + " with " + gearToEdit.getCaracteristics().size() + " caracteristics."));
        }
        editor.getModel().setGear((Gear)gearToEdit);
        ((EditCruiseUI)this.getUI()).getMainPanelLayout().setSelected("gearCaracteristics");
    }
}

