/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.cruise.CruiseCacheLoader;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EditCatchesSupportAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(EditCatchesSupportAction.class);
    protected boolean loadReferential;
    protected boolean loadCruiseCache;

    public EditCatchesSupportAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_FISHING_OPERATION);
    }

    protected abstract boolean isLoadReferential();

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        TuttiDataContext dataContext = this.getDataContext();
        if (doAction) {
            this.loadReferential = this.isLoadReferential();
            this.loadCruiseCache = !dataContext.isCruiseCacheLoaded() || !dataContext.isCruiseCacheUpToDate();
            int totalSteps = 1;
            if (this.loadReferential) {
                totalSteps += 5;
            }
            ++totalSteps;
            ++totalSteps;
            ++totalSteps;
            ++totalSteps;
            ++totalSteps;
            ++totalSteps;
            if (this.loadCruiseCache) {
                long cruiseFishingOperationIds = this.getDataContext().getCruiseFishingOperationIds().stream().count();
                totalSteps = (int)((long)totalSteps + (cruiseFishingOperationIds + 1L));
                if (log.isInfoEnabled()) {
                    log.info((Object)("Found " + cruiseFishingOperationIds + " fishing operations to load in sampling cache."));
                }
            }
            if (totalSteps > 1) {
                ProgressionModel progressionModel = new ProgressionModel();
                progressionModel.setTotal(1);
                this.setProgressionModel(progressionModel);
                progressionModel.adaptTotal(totalSteps);
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        TuttiUIContext context = this.getContext();
        Preconditions.checkState((boolean)context.isCruiseFilled());
        Integer cruiseId = context.getCruiseId();
        if (log.isInfoEnabled()) {
            log.info((Object)("Edit operations of cruise: " + cruiseId));
        }
        context.setValidationContext("edit");
        if (this.loadReferential) {
            this.loadReferantials(false);
        }
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments("Chargement des utilisateurs");
        this.getDataContext().getPersons();
        progressionModel.increments("Chargement de la s\u00e9rie de campagne");
        this.getDataContext().getProgram();
        progressionModel.increments("Chargement de la campagne");
        this.getDataContext().getCruise();
        progressionModel.increments("Chargement des navires");
        this.getDataContext().getScientificVessels();
        this.getDataContext().getFishingVessels();
        progressionModel.increments("Chargement des engins");
        this.getDataContext().getScientificGears();
        this.getDataContext().getFishingGears();
        progressionModel.increments("Chargement des caract\u00e9ristiques");
        this.getDataContext().getCaracteristics();
        if (this.loadCruiseCache) {
            CruiseCacheLoader cruiseCacheLoader = context.createCruiseCacheLoader(progressionModel);
            this.getDataContext().loadCruiseCache(cruiseCacheLoader);
            progressionModel.increments("Chargement de l'interface graphique");
        }
        super.doAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        SwingUtilities.invokeLater(() -> {
            FishingOperationsUI currentBody = (FishingOperationsUI)((MainUIHandler)this.getHandler()).getCurrentBody();
            BeanFilterableComboBox<FishingOperation> comboBox = currentBody.getFishingOperationComboBox();
            if (!comboBox.isEmpty()) {
                FishingOperation selectedOperation = (FishingOperation)comboBox.getData().get(0);
                currentBody.getModel().setSelectedFishingOperation(selectedOperation);
            }
            EditFishingOperationUI fishingOperationTabContent = currentBody.getFishingOperationTabContent();
            JComponent componentToFocus = fishingOperationTabContent.getHandler().getComponentToFocus();
            componentToFocus.requestFocusInWindow();
        });
    }
}

