/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.feed.record;

import fr.ifremer.tutti.ichtyometer.feed.record.IchtyometerFeedReaderMeasureRecord;
import fr.ifremer.tutti.ichtyometer.feed.record.IchtyometerFeedReaderRecordSupport;
import fr.ifremer.tutti.ichtyometer.feed.record.IchtyometerFeedReaderStylusMotionRecord;
import java.util.LinkedHashSet;
import java.util.Set;

public class IchtyometerFeedReaderRecordFactory {
    protected final Set<FeedReaderRecordAceptor> acceptors = new LinkedHashSet<FeedReaderRecordAceptor>();

    public IchtyometerFeedReaderRecordFactory() {
        this.acceptors.add(new FeedReaderRecordAceptor<IchtyometerFeedReaderStylusMotionRecord>(){

            @Override
            public boolean accept(String record) {
                return IchtyometerFeedReaderStylusMotionRecord.acceptRecord(record);
            }

            @Override
            public IchtyometerFeedReaderStylusMotionRecord newRecord(String record) {
                return new IchtyometerFeedReaderStylusMotionRecord(record);
            }
        });
        this.acceptors.add(new FeedReaderRecordAceptor<IchtyometerFeedReaderMeasureRecord>(){

            @Override
            public boolean accept(String record) {
                return IchtyometerFeedReaderMeasureRecord.acceptRecord(record);
            }

            @Override
            public IchtyometerFeedReaderMeasureRecord newRecord(String record) {
                return new IchtyometerFeedReaderMeasureRecord(record);
            }
        });
    }

    public IchtyometerFeedReaderRecordSupport newRecord(String record) {
        IchtyometerFeedReaderRecordSupport feedRecord = null;
        for (FeedReaderRecordAceptor acceptor : this.acceptors) {
            boolean accept = acceptor.accept(record);
            if (!accept) continue;
            feedRecord = (IchtyometerFeedReaderRecordSupport)acceptor.newRecord(record);
            break;
        }
        return feedRecord;
    }

    protected static interface FeedReaderRecordAceptor<F extends IchtyometerFeedReaderRecordSupport> {
        public boolean accept(String var1);

        public F newRecord(String var1);
    }
}

