/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.BluetoothConnectionNotifierServiceRecordAccess;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXServerSessionImpl;
import com.intel.bluetooth.obex.OBEXTCPServiceRecordImpl;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.Connection;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.obex.Authenticator;
import javax.obex.ServerRequestHandler;
import javax.obex.SessionNotifier;

public class OBEXSessionNotifierImpl
implements SessionNotifier,
BluetoothConnectionNotifierServiceRecordAccess {
    private StreamConnectionNotifier notifier;
    private OBEXConnectionParams obexConnectionParams;
    private static final String FQCN = (class$com$intel$bluetooth$obex$OBEXSessionNotifierImpl == null ? (class$com$intel$bluetooth$obex$OBEXSessionNotifierImpl = OBEXSessionNotifierImpl.class$("com.intel.bluetooth.obex.OBEXSessionNotifierImpl")) : class$com$intel$bluetooth$obex$OBEXSessionNotifierImpl).getName();
    private static final Vector fqcnSet = new Vector();
    static /* synthetic */ Class class$com$intel$bluetooth$obex$OBEXSessionNotifierImpl;

    public OBEXSessionNotifierImpl(StreamConnectionNotifier notifier, OBEXConnectionParams obexConnectionParams) throws IOException, Error {
        Utils.isLegalAPICall(fqcnSet);
        this.notifier = notifier;
        this.obexConnectionParams = obexConnectionParams;
    }

    public Connection acceptAndOpen(ServerRequestHandler handler) throws IOException {
        return this.acceptAndOpen(handler, null);
    }

    public synchronized Connection acceptAndOpen(ServerRequestHandler handler, Authenticator auth) throws IOException {
        if (this.notifier == null) {
            throw new IOException("Session closed");
        }
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        OBEXServerSessionImpl sessionImpl = new OBEXServerSessionImpl(this.notifier.acceptAndOpen(), handler, auth, this.obexConnectionParams);
        sessionImpl.startSessionHandlerThread();
        return sessionImpl;
    }

    public void close() throws IOException {
        StreamConnectionNotifier n = this.notifier;
        this.notifier = null;
        if (n != null) {
            n.close();
        }
    }

    public ServiceRecord getServiceRecord() {
        if (this.notifier instanceof ServerSocketConnection) {
            return new OBEXTCPServiceRecordImpl((ServerSocketConnection)this.notifier);
        }
        if (!(this.notifier instanceof BluetoothConnectionNotifierServiceRecordAccess)) {
            throw new IllegalArgumentException("connection is not a Bluetooth notifier");
        }
        return ((BluetoothConnectionNotifierServiceRecordAccess)((Object)this.notifier)).getServiceRecord();
    }

    public void updateServiceRecord(boolean acceptAndOpen) throws ServiceRegistrationException {
        if (!(this.notifier instanceof BluetoothConnectionNotifierServiceRecordAccess)) {
            throw new IllegalArgumentException("connection is not a Bluetooth notifier");
        }
        ((BluetoothConnectionNotifierServiceRecordAccess)((Object)this.notifier)).updateServiceRecord(acceptAndOpen);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fqcnSet.addElement(FQCN);
    }
}

