/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowState;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualObservationToFrequencyEngine {
    private static final Log log = LogFactory.getLog(IndividualObservationToFrequencyEngine.class);
    private final SpeciesFrequencyTableModel frequencyTableModel;
    private final WeightUnit individualObservationWeightUnit;
    private final WeightUnit frequencyWeightUnit;

    public IndividualObservationToFrequencyEngine(SpeciesFrequencyUIModel speciesFrequencyUIModel) {
        this.individualObservationWeightUnit = speciesFrequencyUIModel.getIndividualObservationWeightUnit();
        this.frequencyWeightUnit = speciesFrequencyUIModel.getWeightUnit();
        this.frequencyTableModel = speciesFrequencyUIModel.getFrequencyTableModel();
    }

    public boolean computeFrequencyUpdate(CopyIndividualObservationMode copyIndividualObservationMode, IndividualObservationBatchRowState oldState, IndividualObservationBatchRowState newState) {
        switch (copyIndividualObservationMode) {
            case ALL: {
                this.computeFrequencyUpdateForSizeAndWeight(oldState, newState);
                break;
            }
            case SIZE: {
                this.computeFrequencyUpdateForSizeOnly(oldState, newState);
                break;
            }
            case NOTHING: {
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return oldState.isValid() != newState.isValid();
    }

    public void computeFrequencyUpdateForSizeOnly(IndividualObservationBatchRowState oldState, IndividualObservationBatchRowState newState) {
        boolean sizeChanged;
        Objects.requireNonNull(oldState);
        Objects.requireNonNull(newState);
        Float oldSize = oldState.getSize();
        Float newSize = newState.getSize();
        boolean bl = sizeChanged = !Objects.equals(oldSize, newSize);
        if (sizeChanged) {
            Float decrementSize = null;
            Float incrementSize = null;
            if (oldState.isValid()) {
                decrementSize = oldSize;
            }
            if (newState.isValid()) {
                incrementSize = newSize;
            }
            this.apply(decrementSize, incrementSize, null, null);
        }
    }

    public void computeFrequencyUpdateForSizeAndWeight(IndividualObservationBatchRowState oldState, IndividualObservationBatchRowState newState) {
        boolean weightChanged;
        Objects.requireNonNull(oldState);
        Objects.requireNonNull(newState);
        Float newSize = newState.getSize();
        Float oldSize = oldState.getSize();
        boolean sizeChanged = !Objects.equals(oldSize, newSize);
        Float newWeight = newState.getWeight();
        Float oldWeight = oldState.getWeight();
        boolean bl = weightChanged = !Objects.equals(oldWeight, newWeight);
        if (!sizeChanged && !weightChanged) {
            return;
        }
        boolean oldStateValid = oldState.isValid();
        boolean newStateValid = newState.isValid();
        Float decrementSize = null;
        Float incrementSize = null;
        Pair substractWeight = null;
        Pair addWeight = null;
        if (sizeChanged) {
            if (oldStateValid) {
                decrementSize = oldSize;
                substractWeight = Pair.of((Object)oldSize, (Object)oldWeight);
            }
            if (newStateValid) {
                incrementSize = newSize;
                addWeight = Pair.of((Object)newSize, (Object)newWeight);
            }
        }
        if (weightChanged) {
            Float weightToAdd;
            if (oldStateValid && newStateValid) {
                weightToAdd = Float.valueOf(newWeight.floatValue() - oldWeight.floatValue());
            } else if (oldStateValid) {
                decrementSize = oldSize;
                weightToAdd = Float.valueOf(-oldWeight.floatValue());
            } else if (newStateValid) {
                incrementSize = newSize;
                weightToAdd = newWeight;
            } else {
                weightToAdd = Float.valueOf(0.0f);
            }
            if (this.individualObservationWeightUnit.isNotNullNorZero(weightToAdd)) {
                if (this.individualObservationWeightUnit.isGreaterThanZero(weightToAdd.floatValue())) {
                    addWeight = Pair.of((Object)newSize, (Object)weightToAdd);
                } else {
                    substractWeight = Pair.of((Object)newSize, (Object)Float.valueOf(-weightToAdd.floatValue()));
                }
            }
        }
        this.apply(decrementSize, incrementSize, (Pair<Float, Float>)substractWeight, addWeight);
    }

    private void apply(Float lengthStepToDecrement, Float lengthStepToIncrement, Pair<Float, Float> substractWeight, Pair<Float, Float> addWeight) {
        Float lengthClass;
        float weight;
        if (lengthStepToDecrement != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Decrements frequency rows number for length class: " + lengthStepToDecrement));
            }
            this.frequencyTableModel.decrementFrequencyRowsNumbers(lengthStepToDecrement.floatValue());
        }
        if (lengthStepToIncrement != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Increments frequency rows number for length class: " + lengthStepToIncrement));
            }
            this.frequencyTableModel.incrementFrequencyRowsNumbers(lengthStepToIncrement.floatValue());
        }
        if (substractWeight != null) {
            weight = ((Float)substractWeight.getValue()).floatValue();
            float weightToRemove = this.frequencyTableModel.convertWeightFromIndividualObservation(weight).floatValue();
            lengthClass = (Float)substractWeight.getKey();
            if (log.isInfoEnabled()) {
                log.info((Object)("Substract weight: " + weightToRemove + this.frequencyWeightUnit.getShortLabel() + " for length class: " + lengthClass));
            }
            this.frequencyTableModel.removeWeightToFrequencyRow(lengthClass.floatValue(), weightToRemove);
        }
        if (addWeight != null) {
            weight = ((Float)addWeight.getValue()).floatValue();
            float weightToAdd = this.frequencyTableModel.convertWeightFromIndividualObservation(weight).floatValue();
            lengthClass = (Float)addWeight.getKey();
            if (log.isInfoEnabled()) {
                log.info((Object)("Add weight: " + weightToAdd + this.frequencyWeightUnit.getShortLabel() + " for length class: " + lengthClass));
            }
            this.frequencyTableModel.addWeightToFrequencyRow(lengthClass.floatValue(), weightToAdd);
        }
    }
}

