/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.ArrayList;
import liquibase.Contexts;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.sql.visitor.SqlVisitor;

public class ContextChangeSetFilter
implements ChangeSetFilter {
    private Contexts contexts;

    public ContextChangeSetFilter() {
        this(new Contexts());
    }

    public ContextChangeSetFilter(String ... contexts) {
        this(new Contexts(contexts));
    }

    public ContextChangeSetFilter(Contexts contexts) {
        this.contexts = contexts;
    }

    @Override
    public boolean accepts(ChangeSet changeSet) {
        ArrayList<SqlVisitor> visitorsToRemove = new ArrayList<SqlVisitor>();
        for (SqlVisitor visitor : changeSet.getSqlVisitors()) {
            if (visitor.getContexts() == null || visitor.getContexts().size() <= 0) continue;
            boolean shouldRemove = true;
            for (String context : visitor.getContexts()) {
                if (!this.contexts.contains(context.toLowerCase())) continue;
                shouldRemove = false;
            }
            if (!shouldRemove) continue;
            visitorsToRemove.add(visitor);
        }
        changeSet.getSqlVisitors().removeAll(visitorsToRemove);
        if (this.contexts == null || this.contexts.size() == 0) {
            return true;
        }
        if (changeSet.getContexts() == null || changeSet.getContexts().size() == 0) {
            return true;
        }
        for (String context : changeSet.getContexts()) {
            if (!this.contexts.contains(context.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

