/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesBatchAction
extends LongActionSupport<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    private static final Log log = LogFactory.getLog(RemoveSpeciesBatchAction.class);
    protected Set<SpeciesBatchRowModel> rowToRemove;

    public RemoveSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            int[] selectedRowIndexes = SwingUtil.getSelectedModelRows((JTable)((SpeciesBatchUIHandler)this.handler).getTable());
            int selectedRowCount = selectedRowIndexes.length;
            if (selectedRowCount > 0) {
                String message = selectedRowCount == 1 ? I18n.t((String)"tutti.editSpeciesBatch.action.removeBatch.confirm.message", (Object[])new Object[0]) : I18n.t((String)"tutti.editSpeciesBatch.action.removeBatches.confirm.message", (Object[])new Object[]{selectedRowCount});
                int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), message, I18n.t((String)"tutti.editSpeciesBatch.action.removeBatch.confirm.title", (Object[])new Object[0]), 0);
                result = answer == 0;
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        int[] selectedRowIndexes = SwingUtil.getSelectedModelRows((JTable)((SpeciesBatchUIHandler)this.handler).getTable());
        Preconditions.checkState((selectedRowIndexes.length > 0 ? 1 : 0) != 0, (Object)"Cant remove batches if no batches selected");
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        this.rowToRemove = new HashSet<SpeciesBatchRowModel>();
        for (int rowIndex : selectedRowIndexes) {
            SpeciesBatchRowModel selectedBatch = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
            Preconditions.checkState((!TuttiEntities.isNew((TuttiEntity)selectedBatch) ? 1 : 0) != 0, (Object)"Can't remove batch if batch is not persisted");
            Integer selectedBatchId = selectedBatch.getIdAsInt();
            boolean batchRoot = selectedBatch.isBatchRoot();
            if (!batchRoot && this.rowToRemove.contains(selectedBatch)) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skip to delete species batch: " + selectedBatchId + ", was already removed when his parent was deleted: " + selectedBatch.getParentBatch().getId()));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete species batch: " + selectedBatchId));
            }
            ((SpeciesBatchUIModel)this.getModel()).getSpeciesOrBenthosBatchUISupport().deleteSpeciesBatch(selectedBatchId);
            if (batchRoot) {
                ((SpeciesBatchUIHandler)this.handler).removeFromSpeciesUsed(selectedBatch);
            } else {
                SpeciesBatchRowModel parentBatch = selectedBatch.getParentBatch();
                parentBatch.getChildBatch().remove(selectedBatch);
            }
            this.rowToRemove.add(selectedBatch);
            ((SpeciesBatchUIHandler)this.handler).collectChildren(selectedBatch, this.rowToRemove);
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        ((SpeciesBatchUIModel)this.getModel()).getRows().removeAll(this.rowToRemove);
        ((SpeciesBatchUIHandler)this.handler).getTableModel().fireTableDataChanged();
        TuttiUIUtil.selectFirstCellOnFirstRowAndStopEditing((JXTable)table);
    }
}

