/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.synchro.query.SynchroQueryName;
import fr.ifremer.adagio.synchro.query.SynchroQueryOperator;
import fr.ifremer.adagio.synchro.query.internal.SynchroAbstractQuery;
import fr.ifremer.adagio.synchro.query.internal.SynchroDeleteQuery;
import fr.ifremer.adagio.synchro.query.internal.SynchroInsertQuery;
import fr.ifremer.adagio.synchro.query.internal.SynchroSelectQuery;
import fr.ifremer.adagio.synchro.query.internal.SynchroUpdateQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SynchroQueryBuilder {
    public static final String COLUMN_VALUE_TABLE_SEQUENCE = "~~sequence~~";
    protected static final String ALIAS_VAR = "~~alias~~";
    protected static final String NO_ALIAS_STR = "";
    private static Pattern SELECT_FROM_PATTERN = Pattern.compile("^[\\s]*SELECT(.*)FROM(.+)");
    private static Pattern WHERE_PATTERN = Pattern.compile("^(.*)WHERE(.+)");
    private static Pattern COLUMN_WITH_ALIAS_PATTERN = Pattern.compile("([a-zA-Z0-9_]+)[.]([a-zA-Z0-9_]+)");

    public static SynchroQueryBuilder newBuilder(String sql) {
        return SynchroQueryBuilder.newBuilder(null, sql);
    }

    public static SynchroQueryBuilder newBuilder(SynchroQueryName queryName, String sql) {
        Preconditions.checkNotNull((Object)sql);
        String upperCaseQuery = sql.toUpperCase();
        SynchroAbstractQuery query = null;
        if (upperCaseQuery.startsWith("SELECT")) {
            query = SynchroQueryBuilder.parseSelectQuery(queryName, sql);
        }
        if (upperCaseQuery.startsWith("INSERT")) {
            query = SynchroQueryBuilder.parseInsertQuery(queryName, sql);
        }
        if (upperCaseQuery.startsWith("UPDATE")) {
            query = SynchroQueryBuilder.parseUpdateQuery(queryName, sql);
        }
        if (upperCaseQuery.startsWith("DELETE")) {
            query = SynchroQueryBuilder.parseDeleteQuery(queryName, sql);
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Unable to parse sql: %s", sql));
        }
        return query;
    }

    protected static SynchroAbstractQuery parseSelectQuery(SynchroQueryName queryName, String sql) {
        String tableName;
        Matcher matcher = SELECT_FROM_PATTERN.matcher(sql);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Bad sql query: [%s]. Expected: SELECT <...> FROM <...> WHERE <...>", sql));
        }
        String selectClause = matcher.group(1).trim();
        String fromClause = matcher.group(2).trim();
        matcher = WHERE_PATTERN.matcher(fromClause);
        String whereClause = null;
        if (matcher.matches()) {
            fromClause = matcher.group(1).trim();
            whereClause = matcher.group(2).trim();
        }
        ArrayList columnNames = Lists.newArrayList();
        String tableAlias = null;
        boolean hasColumnDistinct = false;
        if (selectClause.startsWith("DISTINCT")) {
            selectClause = selectClause.substring("DISTINCT".length()).trim();
            hasColumnDistinct = true;
        }
        Iterable parts = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)selectClause);
        for (String columnName : parts) {
            Matcher columnAliasMatcher = COLUMN_WITH_ALIAS_PATTERN.matcher(columnName);
            if (columnAliasMatcher.matches()) {
                if (tableAlias == null) {
                    tableAlias = columnAliasMatcher.group(1);
                }
                columnName = ALIAS_VAR + columnAliasMatcher.group(2);
            }
            columnNames.add(columnName);
        }
        String[] parts2 = fromClause.split("[ \t]+");
        if (parts2.length == 2) {
            tableName = parts2[0];
            tableAlias = parts2[1];
            fromClause = null;
        } else {
            tableName = null;
        }
        SynchroSelectQuery selectQuery = new SynchroSelectQuery(queryName, tableName, columnNames, fromClause, whereClause);
        selectQuery.setTableAlias(tableAlias);
        ((SynchroAbstractQuery)selectQuery).setColumnDistinct(hasColumnDistinct);
        return selectQuery;
    }

    protected static SynchroAbstractQuery parseInsertQuery(SynchroQueryName queryName, String sql) {
        String[] part2;
        ArrayList columnvalues;
        String[] parts = sql.split("(INTO)|(VALUES[ \t\\(]+)");
        if (parts.length != 2 && parts.length != 3) {
            throw new IllegalArgumentException(String.format("Bad sql query: [%s]. Expected: INSERT INTO <...> <...> VALUES <...>", sql));
        }
        String[] part1 = parts[1].trim().split("[ \t,\\(\\)]+");
        ArrayList columnNames = Lists.newArrayList(Arrays.asList(part1));
        String tableName = (String)columnNames.remove(0);
        if (parts[2].lastIndexOf(")") == parts[2].length() - 1) {
            parts[2] = parts[2].substring(0, parts[2].length() - 1);
        }
        if ((columnvalues = Lists.newArrayList(Arrays.asList(part2 = parts[2].trim().split("[\t,\\(\\)]*,[ \t\\(\\)]*")))).size() != columnNames.size()) {
            throw new IllegalArgumentException(String.format("Bad sql query: [%s]. Not same number of columns and values", sql));
        }
        SynchroInsertQuery query = new SynchroInsertQuery(queryName, tableName, (List<String>)columnNames, columnvalues);
        return query;
    }

    protected static SynchroAbstractQuery parseUpdateQuery(SynchroQueryName queryName, String sql) {
        String[] parts = sql.split("(UPDATE)|(SET)|(WHERE)");
        if (parts.length != 3 && parts.length != 4) {
            throw new IllegalArgumentException(String.format("Bad sql query: [%s]. Expected: UPDATE <...> SET <...> WHERE <...>", sql));
        }
        String tableName = parts[1].trim();
        String[] colsAndVal = parts[2].trim().split(",");
        ArrayList columnNames = Lists.newArrayListWithExpectedSize((int)colsAndVal.length);
        ArrayList columnValues = Lists.newArrayListWithExpectedSize((int)colsAndVal.length);
        for (String colAndVal : colsAndVal) {
            String[] colAndValParts = colAndVal.trim().split("[ \t=]+");
            if (colAndValParts.length != 2) {
                throw new IllegalArgumentException(String.format("Bad sql query: [%s]. Expected: UPDATE <...> SET <...> WHERE <...>", sql));
            }
            columnNames.add(colAndValParts[0]);
            columnValues.add(colAndValParts[1]);
        }
        String whereClause = null;
        if (parts.length == 4) {
            whereClause = parts[3].trim();
        }
        SynchroUpdateQuery query = new SynchroUpdateQuery(queryName, tableName, (List<String>)columnNames, columnValues);
        query.setWhereClause(whereClause);
        return query;
    }

    protected static SynchroAbstractQuery parseDeleteQuery(SynchroQueryName queryName, String sql) {
        SynchroDeleteQuery selectQuery = new SynchroDeleteQuery(queryName, null);
        return selectQuery;
    }

    public String build() {
        return this.toSql();
    }

    public abstract String toSql();

    public abstract boolean constainsColumn(String var1);

    public abstract int getColumnCount();

    public abstract String getColumnValue(String var1);

    public abstract List<String> getColumnNames();

    public abstract List<String> getColumnNamesWithAlias();

    public abstract SynchroQueryBuilder replaceColumn(String var1, String var2);

    public abstract SynchroQueryBuilder addColumn(String var1, String var2);

    public abstract SynchroQueryBuilder deleteColumn(String var1);

    public abstract SynchroQueryBuilder deleteColumnIfExists(String var1);

    public abstract SynchroQueryBuilder setColumnValue(String var1, String var2);

    public abstract SynchroQueryBuilder setWhereClause(String var1);

    public abstract SynchroQueryBuilder addWhere(SynchroQueryOperator var1, String var2);

    public abstract SynchroQueryBuilder addWhere(SynchroQueryOperator var1, String var2, String var3);

    public abstract SynchroQueryBuilder addWhere(SynchroQueryOperator var1, String var2, String var3, String var4);

    public abstract SynchroQueryBuilder setColumnDistinct(boolean var1);

    public abstract SynchroQueryBuilder addJoin(String var1);
}

