/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesAbleBatchRowHelper;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import fr.ifremer.tutti.ui.swing.util.species.EnterMelagWeightUI;
import fr.ifremer.tutti.util.Weights;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class CreateSpeciesMelagAction
extends LongActionSupport<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected Map<SpeciesBatchRowModel, Float> selectedRows = Maps.newHashMap();
    protected Float melagWeight;
    protected Float sampleMelagWeight;
    protected Float sortedWeight;
    protected final WeightUnit weightUnit = this.getConfig().getSpeciesWeightUnit();

    public CreateSpeciesMelagAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        int[] selectedRowIndexes = SwingUtil.getSelectedModelRows((JTable)((SpeciesBatchUIHandler)this.handler).getTable());
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        Float alreadyKnownWeights = Float.valueOf(0.0f);
        this.sortedWeight = Float.valueOf(0.0f);
        for (int selectedRowIndex : selectedRowIndexes) {
            SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
            if (selectedRow.getFinestCategory().getNotNullWeight() != null) {
                alreadyKnownWeights = Float.valueOf(alreadyKnownWeights.floatValue() + selectedRow.getFinestCategory().getNotNullWeight().floatValue());
                this.selectedRows.put(selectedRow, null);
                continue;
            }
            Float sampleWeight = selectedRow.getWeight() != null ? selectedRow.getWeight() : SpeciesAbleBatchRowHelper.getFrequenciesTotalWeight(selectedRow.getFrequency());
            if (sampleWeight == null) {
                JOptionPane.showMessageDialog(this.getDialogParentComponent(), I18n.t((String)"tutti.createSpeciesMelag.error.message", (Object[])new Object[]{selectedRowIndex + 1}), I18n.t((String)"tutti.createSpeciesMelag.error.title", (Object[])new Object[0]), 0);
                SwingUtil.setSelectionInterval((JTable)((SpeciesBatchUIHandler)this.handler).getTable(), (int)selectedRowIndex);
                result = false;
                break;
            }
            this.sortedWeight = Float.valueOf(this.sortedWeight.floatValue() + sampleWeight.floatValue());
            this.selectedRows.put(selectedRow, sampleWeight);
        }
        if (result) {
            EnterMelagWeightUI dialog = new EnterMelagWeightUI(this.getContext());
            this.melagWeight = dialog.openAndGetWeightValue(this.weightUnit);
            boolean bl = result = this.melagWeight != null;
        }
        if (result) {
            this.sampleMelagWeight = Float.valueOf(this.melagWeight.floatValue() - alreadyKnownWeights.floatValue());
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        String unitLabel = this.weightUnit.getShortLabel();
        String melagComment = I18n.t((String)"tutti.createSpeciesMelag.comment.part1", (Object[])new Object[0]) + "\n";
        for (SpeciesBatchRowModel batch : this.selectedRows.keySet()) {
            Float sampleWeight = this.selectedRows.get(batch);
            if (sampleWeight == null) {
                sampleWeight = batch.getFinestCategory().getNotNullWeight();
            } else {
                float categoryWeight = Weights.roundKiloGram(this.sampleMelagWeight.floatValue() * sampleWeight.floatValue() / this.sortedWeight.floatValue());
                batch.getFinestCategory().setCategoryWeight(Float.valueOf(categoryWeight));
            }
            melagComment = melagComment + I18n.t((String)"tutti.createSpeciesMelag.comment.part2", (Object[])new Object[]{sampleWeight, unitLabel, this.decorate(batch.getSpecies())}) + "\n";
        }
        melagComment = melagComment + I18n.t((String)"tutti.createSpeciesMelag.comment.part3", (Object[])new Object[]{this.melagWeight, unitLabel});
        for (SpeciesBatchRowModel batch : this.selectedRows.keySet()) {
            String comment = batch.getComment();
            comment = StringUtils.isBlank((CharSequence)comment) ? "" : comment + "\n";
            comment = comment + melagComment;
            batch.setComment(comment);
        }
        ((SpeciesBatchUIHandler)this.getHandler()).saveRows(this.selectedRows.keySet());
    }

    public void releaseAction() {
        this.selectedRows.clear();
        this.sampleMelagWeight = null;
        this.melagWeight = null;
        this.sortedWeight = null;
        super.releaseAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((SpeciesBatchUIHandler)this.getHandler()).getTable().repaint();
    }
}

