/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import fr.ifremer.adagio.synchro.service.SynchroTableOperation;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SynchroContext {
    protected SynchroDatabaseConfiguration sourceDatabaseConfiguration;
    protected SynchroDatabaseMetadata sourceMeta;
    protected SynchroDatabaseConfiguration targetDatabaseConfiguration;
    protected SynchroDatabaseMetadata targetMeta;
    protected SynchroResult result;
    protected Set<String> tableNames;
    protected Map<String, SynchroTableOperation> tableContextMap;
    protected Timestamp lastSynchronizationDate;

    public static SynchroContext newContext(Set<String> tableNames, Properties sourceConnectionProperties, Properties targetConnectionProperties, SynchroResult result) {
        Preconditions.checkNotNull((Object)sourceConnectionProperties);
        Preconditions.checkNotNull((Object)targetConnectionProperties);
        SynchroConfiguration config = SynchroConfiguration.getInstance();
        return SynchroContext.newContext(tableNames, new SynchroDatabaseConfiguration(config, sourceConnectionProperties, false), new SynchroDatabaseConfiguration(config, targetConnectionProperties, true), result);
    }

    public static SynchroContext newContext(Set<String> tableNames, SynchroDatabaseConfiguration source, SynchroDatabaseConfiguration target, SynchroResult result) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        SynchroContext context = new SynchroContext();
        context.setTableNames(tableNames);
        context.setSource(source);
        context.setTarget(target);
        context.setResult(result);
        return context;
    }

    public SynchroContext() {
        this.tableContextMap = Maps.newHashMap();
    }

    public SynchroContext(SynchroContext otherBean) {
        this.copy(otherBean);
    }

    public SynchroResult getResult() {
        return this.result;
    }

    public void setResult(SynchroResult result) {
        this.result = result;
    }

    public void setSource(SynchroDatabaseConfiguration sourceSettings) {
        this.sourceDatabaseConfiguration = sourceSettings;
    }

    public void setTarget(SynchroDatabaseConfiguration targetSettings) {
        this.targetDatabaseConfiguration = targetSettings;
    }

    public void setTableNames(Set<String> tableNames) {
        this.tableNames = tableNames;
    }

    public SynchroDatabaseConfiguration getSource() {
        return this.sourceDatabaseConfiguration;
    }

    public SynchroDatabaseConfiguration getTarget() {
        return this.targetDatabaseConfiguration;
    }

    public Set<String> getTableNames() {
        return this.tableNames;
    }

    public Timestamp getLastSynchronizationDate() {
        return this.lastSynchronizationDate;
    }

    public void setLastSynchronizationDate(Timestamp lastSynchronizationDate) {
        this.lastSynchronizationDate = lastSynchronizationDate;
    }

    public SynchroDatabaseMetadata getSourceMeta() {
        return this.sourceMeta;
    }

    public void setSourceMeta(SynchroDatabaseMetadata sourceMeta) {
        this.sourceMeta = sourceMeta;
    }

    public SynchroDatabaseMetadata getTargetMeta() {
        return this.targetMeta;
    }

    public void setTargetMeta(SynchroDatabaseMetadata targetMeta) {
        this.targetMeta = targetMeta;
    }

    public SynchroDatabaseMetadata getMeta(SynchroDatabaseConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        if (configuration == this.targetDatabaseConfiguration) {
            return this.targetMeta;
        }
        return this.sourceMeta;
    }

    public SynchroDatabaseMetadata getMetaWithQueryEnable() {
        Preconditions.checkNotNull((Object)this.targetDatabaseConfiguration);
        Preconditions.checkNotNull((Object)this.sourceDatabaseConfiguration);
        Preconditions.checkNotNull((Object)this.targetMeta);
        Preconditions.checkNotNull((Object)this.sourceMeta);
        Preconditions.checkArgument((this.targetDatabaseConfiguration.isFullMetadataEnable() || this.sourceDatabaseConfiguration.isFullMetadataEnable() ? 1 : 0) != 0);
        if (this.targetDatabaseConfiguration.isFullMetadataEnable()) {
            return this.targetMeta;
        }
        return this.sourceMeta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("synchronisation context:");
        if (this.getSource() != null) {
            sb.append("\n  ").append(this.getSource().toString());
        }
        if (this.getTarget() != null) {
            sb.append("\n  ").append(this.getTarget().toString());
        }
        sb.append("\n  table includes: ");
        if (this.getTableNames() != null) {
            sb.append(Joiner.on((char)',').join(this.getTableNames()));
        }
        sb.append("\n  last synchronization date: ").append(this.getLastSynchronizationDate());
        return sb.toString();
    }

    public void copy(SynchroContext otherBean) {
        this.tableContextMap = otherBean.tableContextMap;
        this.result = otherBean.result;
        this.sourceDatabaseConfiguration = otherBean.sourceDatabaseConfiguration;
        this.sourceMeta = otherBean.sourceMeta;
        this.targetDatabaseConfiguration = otherBean.targetDatabaseConfiguration;
        this.targetMeta = otherBean.targetMeta;
        this.tableNames = otherBean.tableNames;
        this.tableContextMap = otherBean.tableContextMap;
        this.lastSynchronizationDate = otherBean.lastSynchronizationDate;
    }
}

