/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import java.util.Map;

public enum Signs {
    MALE("1", PmfmId.SEX, QualitativeValueId.SEX_MALE),
    FEMALE("2", PmfmId.SEX, QualitativeValueId.SEX_FEMALE),
    SMALL("P", PmfmId.SIZE_CATEGORY, QualitativeValueId.SIZE_SMALL),
    MEDIUM("M", PmfmId.SIZE_CATEGORY, QualitativeValueId.SIZE_MEDIUM),
    BIG("G", PmfmId.SIZE_CATEGORY, QualitativeValueId.SIZE_BIG),
    DEFAULT("0", PmfmId.SEX, QualitativeValueId.SEX_UNDEFINED),
    UNSORTED("H", null, null),
    MELAG("T", null, null);

    private final String sign;
    private final Integer category;
    private final Integer qualitativeValue;

    private Signs(String sign, PmfmId pmfmId, QualitativeValueId qualitativeValueId) {
        this.sign = sign;
        this.category = pmfmId == null ? null : pmfmId.getValue();
        this.qualitativeValue = qualitativeValueId == null ? null : qualitativeValueId.getValue();
    }

    public String getSign() {
        return this.sign;
    }

    public static Signs getSign(String sign) {
        Signs result = null;
        for (Signs s : Signs.values()) {
            if (!s.sign.equals(sign)) continue;
            result = s;
            break;
        }
        return result;
    }

    public Integer getCategory() {
        return this.category;
    }

    public Integer getQualitativeValue() {
        return this.qualitativeValue;
    }

    public void registerSign(Caracteristic caracteristic, Map<Signs, CaracteristicQualitativeValue> map) {
        CaracteristicQualitativeValue result = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)this.qualitativeValue);
        map.put(this, result);
    }
}

