/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;

public class DirectedGraph {
    private Set<DirectedGraphEdge> edges;
    private Map<GraphNode, Set<DirectedGraphEdge>> groupedEdgesByFromNode;

    public DirectedGraph(Set<DirectedGraphEdge> edges) {
        assert (edges != null);
        this.edges = edges;
    }

    public GraphNode[] flattenNodesByDependency() throws CycleFoundException {
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        HashSet<GraphNode> flatteneds = new HashSet<GraphNode>();
        Map<GraphNode, Set<DirectedGraphEdge>> groupedEdgesByFromNode = this.groupEdgesByFromNode();
        for (GraphNode fromNode : groupedEdgesByFromNode.keySet()) {
            if (flatteneds.contains(fromNode)) continue;
            this.addToFlattened(fromNode, result, new HashSet<GraphNode>(), flatteneds);
        }
        return result.toArray(new GraphNode[0]);
    }

    public boolean isDependOn(GraphNode node1, GraphNode node2) {
        assert (node1 != null && node2 != null);
        Map<GraphNode, Set<DirectedGraphEdge>> groupedEdgesByFromNode = this.groupEdgesByFromNode();
        Set<DirectedGraphEdge> nextEdges = groupedEdgesByFromNode.get(node1);
        if (nextEdges == null) {
            return false;
        }
        for (DirectedGraphEdge edge : nextEdges) {
            if (node2.equals(edge.getTo())) {
                return true;
            }
            if (!this.isDependOn(edge.getTo(), node2)) continue;
            return true;
        }
        return false;
    }

    private void addToFlattened(GraphNode node, List<GraphNode> result, Set<GraphNode> transitions, Set<GraphNode> flatteneds) throws CycleFoundException {
        transitions.add(node);
        Set<DirectedGraphEdge> nextEdges = this.groupedEdgesByFromNode.get(node);
        if (nextEdges != null) {
            for (DirectedGraphEdge edge : nextEdges) {
                GraphNode nextNode = edge.getTo();
                if (transitions.contains(nextNode)) {
                    throw new CycleFoundException(node);
                }
                if (flatteneds.contains(nextNode)) continue;
                transitions.add(nextNode);
                this.addToFlattened(nextNode, result, transitions, flatteneds);
                transitions.remove(nextNode);
            }
        }
        result.add(node);
        flatteneds.add(node);
    }

    public void validateCycle() throws CycleFoundException {
        Map<GraphNode, Set<DirectedGraphEdge>> groupedEdgesByFromNode = this.groupEdgesByFromNode();
        HashSet<GraphNode> checkedNodes = new HashSet<GraphNode>();
        for (GraphNode fromNode : groupedEdgesByFromNode.keySet()) {
            if (checkedNodes.contains(fromNode)) continue;
            Set<GraphNode> reachables = this.getReachableNodes(fromNode, new HashSet<GraphNode>(), groupedEdgesByFromNode);
            checkedNodes.addAll(reachables);
            checkedNodes.add(fromNode);
        }
    }

    private Set<GraphNode> getReachableNodes(GraphNode fromNode, Set<GraphNode> transitions, Map<GraphNode, Set<DirectedGraphEdge>> groupedEdges) throws CycleFoundException {
        HashSet<GraphNode> reachables = new HashSet<GraphNode>();
        Set<DirectedGraphEdge> nextEdges = groupedEdges.get(fromNode);
        if (nextEdges != null) {
            for (DirectedGraphEdge edge : nextEdges) {
                if (edge.getTo().equals(fromNode)) {
                    throw new CycleFoundException(fromNode);
                }
                GraphNode reachable = edge.getTo();
                if (transitions.contains(reachable)) {
                    throw new CycleFoundException(fromNode);
                }
                if (reachables.contains(reachable)) continue;
                reachables.add(reachable);
                HashSet<GraphNode> newTransitons = new HashSet<GraphNode>(transitions);
                newTransitons.add(fromNode);
                reachables.addAll(this.getReachableNodes(reachable, newTransitons, groupedEdges));
            }
        }
        return reachables;
    }

    private Map<GraphNode, Set<DirectedGraphEdge>> groupEdgesByFromNode() {
        if (this.groupedEdgesByFromNode == null) {
            this.groupedEdgesByFromNode = new HashMap<GraphNode, Set<DirectedGraphEdge>>();
            for (DirectedGraphEdge edge : this.edges) {
                Set<DirectedGraphEdge> group = this.groupedEdgesByFromNode.get(edge.getFrom());
                if (group == null) {
                    group = new HashSet<DirectedGraphEdge>();
                    this.groupedEdgesByFromNode.put(edge.getFrom(), group);
                }
                group.add(edge);
            }
        }
        return this.groupedEdgesByFromNode;
    }

    public static class CycleFoundException
    extends Exception {
        private GraphNode node;

        public CycleFoundException(GraphNode node) {
            this.node = node;
        }

        public GraphNode getNode() {
            return this.node;
        }
    }
}

