/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.model;

import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.model.DataModelSupport;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import java.util.Iterator;
import java.util.Set;

public class CruiseDataModel
extends DataModelSupport
implements Iterable<OperationDataModel> {
    private static final long serialVersionUID = 1L;
    private final Set<OperationDataModel> operations;

    public CruiseDataModel(Cruise cruise, Set<OperationDataModel> operations) {
        this(cruise.getId(), cruise.getName(), operations);
    }

    public CruiseDataModel(String id, String label, Set<OperationDataModel> operations) {
        super(id, label);
        this.operations = ImmutableSet.copyOf(operations);
    }

    @Override
    public Iterator<OperationDataModel> iterator() {
        return this.operations.iterator();
    }

    public int size() {
        return this.operations.size();
    }

    public OperationDataModel getOperation(String id) {
        OperationDataModel result = null;
        for (OperationDataModel operation : this) {
            if (!id.equals(operation.getId())) continue;
            result = operation;
            break;
        }
        return result;
    }
}

