/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveCaracteristicMappingAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    protected Set<Caracteristic> removedCarateristics;
    protected Set<EditProtocolCaracteristicsRowModel> removedRows;
    protected List<Integer> removedRowIndexes;

    public RemoveCaracteristicMappingAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        JXTable table = ((EditProtocolUIHandler)this.handler).getCaracteristicsMappingTable();
        Preconditions.checkState((!table.getSelectionModel().isSelectionEmpty() ? 1 : 0) != 0);
        EditProtocolCaracteristicsTableModel tableModel = (EditProtocolCaracteristicsTableModel)((Object)table.getModel());
        this.removedCarateristics = Sets.newHashSet();
        this.removedRows = Sets.newHashSet();
        this.removedRowIndexes = new ArrayList<Integer>();
        int[] arr$ = SwingUtil.getSelectedModelRows((JTable)table);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer rowIndex = arr$[i$];
            this.removedRowIndexes.add(rowIndex);
            EditProtocolCaracteristicsRowModel selectedRow = (EditProtocolCaracteristicsRowModel)tableModel.getEntry(rowIndex);
            Caracteristic caracteristic = selectedRow.getPsfm();
            this.removedCarateristics.add(caracteristic);
            this.removedRows.add(selectedRow);
        }
        Collections.sort(this.removedRowIndexes, Collections.reverseOrder());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditProtocolUI)this.getUI()).getCaracteristicMappingComboBox().addItems(this.removedCarateristics);
        ((EditProtocolUIModel)this.getModel()).removeCaracteristicMappingRows(this.removedRows);
        JXTable table = ((EditProtocolUIHandler)this.handler).getCaracteristicsMappingTable();
        EditProtocolCaracteristicsTableModel tableModel = (EditProtocolCaracteristicsTableModel)((Object)table.getModel());
        for (Integer rowIndex : this.removedRowIndexes) {
            tableModel.removeRow(rowIndex);
        }
        table.clearSelection();
        this.sendMessage(I18n.t((String)"tutti.flash.info.caracteristicMapping.remove.from.protocol", (Object[])new Object[0]));
    }
}

