/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import fr.ifremer.tutti.util.Numbers;
import fr.ifremer.tutti.util.Weights;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.validator.NuitonValidatorResult;

public class WeightComputingService
extends AbstractTuttiService {
    protected PersistenceService persistenceService;
    protected ValidationService validationService;
    protected DecoratorService decoratorService;
    private int currentSpeciesRowIndex;
    private int currentBenthosRowIndex;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.validationService = this.getService(ValidationService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public void computeCatchBatchWeights(CatchBatch catchBatch, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch, BatchContainer<MarineLitterBatch> rootMarineLitterBatch) {
        Float marineLitterTotalWeight;
        Float inertWeight;
        Float speciesTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float speciesTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        if (rootSpeciesBatch != null) {
            SpeciesBatch row;
            Float weight;
            List speciesBatches = rootSpeciesBatch.getChildren();
            Iterator i$ = speciesBatches.iterator();
            while (i$.hasNext() && (weight = (Float)Numbers.getValueOrComputedValue((Number)(row = (SpeciesBatch)i$.next()).getSampleCategoryWeight(), (Number)row.getSampleCategoryComputedWeight())) != null) {
                if (this.persistenceService.isVracBatch((SpeciesAbleBatch)row)) {
                    speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + weight.floatValue());
                    continue;
                }
                speciesTotalComputedUnsortedWeight = Float.valueOf(speciesTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
            }
        }
        if ((inertWeight = catchBatch.getSpeciesTotalInertWeight()) != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            catchBatch.setSpeciesTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        Float livingNotItemizedWeight = catchBatch.getSpeciesTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            catchBatch.setSpeciesTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setSpeciesTotalSampleSortedComputedWeight(speciesTotalComputedSortedWeight);
        Float speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedWeight();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = speciesTotalComputedSortedWeight;
            catchBatch.setSpeciesTotalSortedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)speciesTotalSortedWeight.floatValue())));
        } else if (speciesTotalSortedWeight.floatValue() < speciesTotalComputedSortedWeight.floatValue()) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentTotalSorted", (Object[])new Object[0]));
        }
        catchBatch.setSpeciesTotalUnsortedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)speciesTotalComputedUnsortedWeight.floatValue())));
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedComputedWeight();
        }
        Float benthosTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float benthosTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        if (rootBenthosBatch != null) {
            BenthosBatch row;
            Float weight;
            List benthosBatches = rootBenthosBatch.getChildren();
            Iterator i$ = benthosBatches.iterator();
            while (i$.hasNext() && (weight = (Float)Numbers.getValueOrComputedValue((Number)(row = (BenthosBatch)i$.next()).getSampleCategoryWeight(), (Number)row.getSampleCategoryComputedWeight())) != null) {
                if (this.persistenceService.isVracBatch((SpeciesAbleBatch)row)) {
                    benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + weight.floatValue());
                    continue;
                }
                benthosTotalComputedUnsortedWeight = Float.valueOf(benthosTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
            }
        }
        if ((inertWeight = catchBatch.getBenthosTotalInertWeight()) != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            catchBatch.setBenthosTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        livingNotItemizedWeight = catchBatch.getBenthosTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            catchBatch.setBenthosTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setBenthosTotalSampleSortedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)benthosTotalComputedSortedWeight.floatValue())));
        Float benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedWeight();
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = benthosTotalComputedSortedWeight;
            catchBatch.setBenthosTotalSortedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)benthosTotalSortedWeight.floatValue())));
        } else if (benthosTotalSortedWeight.floatValue() < benthosTotalComputedSortedWeight.floatValue()) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentTotalSorted", (Object[])new Object[0]));
        }
        catchBatch.setBenthosTotalUnsortedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)benthosTotalComputedUnsortedWeight.floatValue())));
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedComputedWeight();
        }
        Float marineLitterTotalComputedWeight = Float.valueOf(0.0f);
        if (rootMarineLitterBatch != null) {
            List marineLitterBatches = rootMarineLitterBatch.getChildren();
            for (MarineLitterBatch row : marineLitterBatches) {
                Float rowWeight = row.getWeight();
                if (rowWeight == null) {
                    marineLitterTotalComputedWeight = null;
                    break;
                }
                marineLitterTotalComputedWeight = Float.valueOf(marineLitterTotalComputedWeight.floatValue() + rowWeight.floatValue());
            }
        }
        if (marineLitterTotalComputedWeight != null) {
            catchBatch.setMarineLitterTotalComputedWeight(Float.valueOf(Weights.roundKiloGram((float)marineLitterTotalComputedWeight.floatValue())));
        }
        if ((marineLitterTotalWeight = catchBatch.getMarineLitterTotalWeight()) == null) {
            marineLitterTotalWeight = marineLitterTotalComputedWeight;
        } else if (marineLitterTotalComputedWeight != null && marineLitterTotalWeight.floatValue() < marineLitterTotalComputedWeight.floatValue()) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.marineLitter.incoherentTotal", (Object[])new Object[0]));
        }
        Float totalUnsortedWeight = Float.valueOf(catchBatch.getSpeciesTotalUnsortedComputedWeight().floatValue() + catchBatch.getBenthosTotalUnsortedComputedWeight().floatValue());
        Float totalSortedSortedWeight = Float.valueOf(speciesTotalSortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        catchBatch.setCatchTotalSortedSortedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)totalSortedSortedWeight.floatValue())));
        catchBatch.setCatchTotalUnsortedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)totalUnsortedWeight.floatValue())));
        Float totalWeight = catchBatch.getCatchTotalWeight();
        Float rejectedWeight = catchBatch.getCatchTotalRejectedWeight();
        if (rejectedWeight == null && totalWeight != null) {
            if (Weights.isNotEqualWeight((float)totalWeight.floatValue(), (float)(totalUnsortedWeight.floatValue() + totalSortedSortedWeight.floatValue()))) {
                throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
            }
            catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)(totalWeight.floatValue() - totalUnsortedWeight.floatValue() - totalSortedSortedWeight.floatValue()))));
        } else if (totalWeight == null) {
            if (rejectedWeight == null) {
                rejectedWeight = Float.valueOf(0.0f);
                catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(0.0f));
            }
            catchBatch.setCatchTotalComputedWeight(Float.valueOf(Weights.roundKiloGram((float)(totalUnsortedWeight.floatValue() + totalSortedSortedWeight.floatValue() + rejectedWeight.floatValue()))));
        } else if (Weights.isNotEqualWeight((float)totalWeight.floatValue(), (float)(totalUnsortedWeight.floatValue() + totalSortedSortedWeight.floatValue() + rejectedWeight.floatValue()))) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
        }
        Float totalSortedWeight = totalSortedSortedWeight;
        if (rejectedWeight != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + rejectedWeight.floatValue());
        }
        catchBatch.setCatchTotalSortedComputedWeight(Float.valueOf(Weights.roundKiloGram((float)totalSortedWeight.floatValue())));
        Float catchRate = Weights.isEqualWeight((float)totalSortedSortedWeight.floatValue(), (float)0.0f) ? Float.valueOf(0.0f) : Float.valueOf(totalSortedWeight.floatValue() / totalSortedSortedWeight.floatValue());
        Float speciesTotalWeight = Float.valueOf(speciesTotalSortedWeight.floatValue() * catchRate.floatValue() + speciesTotalComputedUnsortedWeight.floatValue());
        catchBatch.setSpeciesTotalComputedWeight(Float.valueOf(Weights.roundKiloGram((float)speciesTotalWeight.floatValue())));
        Float benthosTotalWeight = Float.valueOf(benthosTotalSortedWeight.floatValue() * catchRate.floatValue() + benthosTotalComputedUnsortedWeight.floatValue());
        catchBatch.setBenthosTotalComputedWeight(Float.valueOf(Weights.roundKiloGram((float)benthosTotalWeight.floatValue())));
    }

    public BatchContainer<SpeciesBatch> getComputedSpeciesBatches(String operationId) {
        BatchContainer<SpeciesBatch> rootSpeciesBatch = null;
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operationId, false);
            this.currentSpeciesRowIndex = 0;
            if (rootSpeciesBatch != null) {
                List roots = rootSpeciesBatch.getChildren();
                for (SpeciesBatch batch : roots) {
                    this.computeSpeciesBatch(batch);
                }
            }
        }
        return rootSpeciesBatch;
    }

    protected String getCategoryLabel(Integer sampleCategoryId) {
        SampleCategoryModelEntry category = this.context.getSampleCategoryModel().getCategoryById(sampleCategoryId);
        String result = category.getLabel();
        return result;
    }

    public Float computeSpeciesBatch(SpeciesBatch batch) {
        Float result = null;
        int thisIndex = this.currentSpeciesRowIndex++;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        String species = this.decoratorService.getDecoratorByType(Species.class).toString((Object)batch.getSpecies());
        String categoryValue = this.decoratorService.getDecorator(batch.getSampleCategoryValue()).toString((Object)batch.getSampleCategoryValue());
        NuitonValidatorResult validation = this.validationService.validateEditSpeciesBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
            throw new TuttiWeightComputingException(I18n.t((String)((String)messages.get(0)), (Object[])new Object[]{species, categoryLabel, categoryValue, batch.getWeight(), batch.getSampleCategoryWeight()}), "weight", thisIndex);
        }
        List children = batch.getChildBatchs();
        if (batch.sizeChildBatchs() > 0) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatch child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(Float.valueOf(Weights.roundKiloGram((float)sum.floatValue())));
                } else {
                    if (Weights.isSmallerWeight((float)categoryWeight.floatValue(), (float)sum.floatValue())) {
                        String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                        throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentParentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, categoryWeight, sum}), "sampleCategoryWeight", thisIndex);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (SpeciesBatchFrequency frequency : frequencies) {
                    Float w = frequency.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight != null || rowWeight == null) {
                    String categoryLabel;
                    if (rowWeight != null && frequencyWeight != null && Weights.isNotEqualWeight((float)rowWeight.floatValue(), (float)frequencyWeight.floatValue())) {
                        categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                        throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentRowWeightFrequency", (Object[])new Object[]{species, categoryLabel, categoryValue, frequencyWeight, rowWeight}), "weight", thisIndex);
                    }
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(Float.valueOf(Weights.roundKiloGram((float)frequencyWeight.floatValue())));
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && Weights.isNotEqualWeight((float)frequencyWeight.floatValue(), (float)categoryWeight.floatValue())) {
                        if (Weights.isGreaterWeight((float)frequencyWeight.floatValue(), (float)categoryWeight.floatValue())) {
                            categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                            throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, frequencyWeight, categoryWeight}), "sampleCategoryWeight", thisIndex);
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(Float.valueOf(Weights.roundKiloGram((float)frequencyWeight.floatValue())));
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
                Integer frequencyNumber = 0;
                for (SpeciesBatchFrequency frequency : frequencies) {
                    Integer c = frequency.getNumber();
                    frequencyNumber = frequencyNumber + c;
                }
                batch.setComputedNumber(frequencyNumber);
            } else {
                result = categoryWeight;
            }
        }
        if (Weights.isNullOrZero(result)) {
            String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
            throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.noWeight", (Object[])new Object[]{species, categoryLabel, categoryValue}), "sampleCategoryWeight", thisIndex);
        }
        return Float.valueOf(Weights.roundKiloGram((float)result.floatValue()));
    }

    public BatchContainer<BenthosBatch> getComputedBenthosBatches(String operationId) {
        BatchContainer<BenthosBatch> rootBenthosBatch = null;
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            rootBenthosBatch = this.persistenceService.getRootBenthosBatch(operationId, false);
            this.currentBenthosRowIndex = 0;
            if (rootBenthosBatch != null) {
                List roots = rootBenthosBatch.getChildren();
                for (BenthosBatch batch : roots) {
                    this.computeBenthosBatch(batch);
                }
            }
        }
        return rootBenthosBatch;
    }

    public Float computeBenthosBatch(BenthosBatch batch) {
        Float result = null;
        int thisIndex = this.currentBenthosRowIndex++;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        String species = this.decoratorService.getDecoratorByType(Species.class).toString((Object)batch.getSpecies());
        String categoryValue = this.decoratorService.getDecorator(batch.getSampleCategoryValue()).toString((Object)batch.getSampleCategoryValue());
        NuitonValidatorResult validation = this.validationService.validateEditBenthosBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
            throw new TuttiWeightComputingException(I18n.t((String)((String)messages.get(0)), (Object[])new Object[]{species, categoryLabel, categoryValue, batch.getWeight(), batch.getSampleCategoryWeight()}), "weight", thisIndex);
        }
        List children = batch.getChildBatchs();
        if (!batch.isChildBatchsEmpty()) {
            Float sum = Float.valueOf(0.0f);
            for (BenthosBatch child : children) {
                Float weight = this.computeBenthosBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(Float.valueOf(Weights.roundKiloGram((float)sum.floatValue())));
                } else {
                    if (Weights.isSmallerWeight((float)categoryWeight.floatValue(), (float)sum.floatValue())) {
                        String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                        throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentParentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, categoryWeight, sum}), "sampleCategoryWeight", thisIndex);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<BenthosBatchFrequency> frequencies = this.persistenceService.getAllBenthosBatchFrequency(batch.getId());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (BenthosBatchFrequency frequency : frequencies) {
                    Float w = frequency.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight != null || rowWeight == null) {
                    String categoryLabel;
                    if (rowWeight != null && frequencyWeight != null && Weights.isNotEqualWeight((float)rowWeight.floatValue(), (float)frequencyWeight.floatValue())) {
                        categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                        throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentRowWeightFrequency", (Object[])new Object[]{species, categoryLabel, categoryValue, rowWeight, categoryWeight}), "weight", thisIndex);
                    }
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(Float.valueOf(Weights.roundKiloGram((float)frequencyWeight.floatValue())));
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && Weights.isNotEqualWeight((float)frequencyWeight.floatValue(), (float)categoryWeight.floatValue())) {
                        if (Weights.isGreaterWeight((float)frequencyWeight.floatValue(), (float)categoryWeight.floatValue())) {
                            categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                            throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, frequencyWeight, categoryWeight}), "sampleCategoryWeight", thisIndex);
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(Float.valueOf(Weights.roundKiloGram((float)frequencyWeight.floatValue())));
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
                Integer frequencyNumber = 0;
                for (BenthosBatchFrequency frequency : frequencies) {
                    Integer c = frequency.getNumber();
                    frequencyNumber = frequencyNumber + c;
                }
                batch.setComputedNumber(frequencyNumber);
            } else {
                result = categoryWeight;
            }
        }
        if (Weights.isNullOrZero(result)) {
            String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
            throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.noWeight", (Object[])new Object[]{species, categoryLabel, categoryValue}), "sampleCategoryWeight", thisIndex);
        }
        return Float.valueOf(Weights.roundKiloGram((float)result.floatValue()));
    }

    public BatchContainer<MarineLitterBatch> getComputedMarineLitterBatches(String fishingOperationId, Float marineLitterweight) {
        BatchContainer<MarineLitterBatch> rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
        if (rootMarineLitterBatch != null) {
            boolean checkWeight = marineLitterweight == null;
            List children = rootMarineLitterBatch.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                MarineLitterBatch batch = (MarineLitterBatch)children.get(i);
                if (!checkWeight || !Weights.isNullOrZero((Float)batch.getWeight())) continue;
                throw new TuttiWeightComputingException(I18n.t((String)"tutti.validator.warning.marineLitter.weight.required", (Object[])new Object[0]), "weight", i);
            }
        }
        return rootMarineLitterBatch;
    }
}

