/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.action;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import fr.ifremer.adagio.core.service.ServiceLocator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Version;

public class DatabaseUpdateAction {
    private static final Log log = LogFactory.getLog(DatabaseUpdateAction.class);

    public void run() {
        boolean isValidConnection;
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        if (log.isInfoEnabled()) {
            String jdbcSchema;
            log.info((Object)"Starting database schema update...");
            boolean isFileDatabase = DaoUtils.isFileDatabase(config.getJdbcDriver());
            if (isFileDatabase) {
                log.info((Object)String.format(" Database directory: %s", AdagioConfiguration.getInstance().getDbDirectory()));
            }
            log.info((Object)String.format(" JDBC Driver: %s", AdagioConfiguration.getInstance().getJdbcDriver()));
            log.info((Object)String.format(" JDBC URL: %s", AdagioConfiguration.getInstance().getJdbcURL()));
            log.info((Object)String.format(" JDBC Username: %s", AdagioConfiguration.getInstance().getJdbcUsername()));
            String jdbcCatalog = config.getJdbcCatalog();
            if (StringUtils.isNotBlank((CharSequence)jdbcCatalog)) {
                log.info((Object)String.format(" JDBC Catalog: %s", jdbcCatalog));
            }
            if (StringUtils.isNotBlank((CharSequence)(jdbcSchema = config.getJdbcSchema()))) {
                log.info((Object)String.format(" JDBC Schema: %s", jdbcSchema));
            }
        }
        if (!(isValidConnection = DaoUtils.isValidConnectionProperties(AdagioConfiguration.getInstance().getJdbcDriver(), AdagioConfiguration.getInstance().getJdbcURL(), AdagioConfiguration.getInstance().getJdbcUsername(), AdagioConfiguration.getInstance().getJdbcPassword()))) {
            log.warn((Object)"Connection error: could not update the schema.");
            return;
        }
        DatabaseSchemaService databaseSchemaService = ServiceLocator.instance().getService("databaseSchemaService", DatabaseSchemaService.class);
        if (!databaseSchemaService.isDbLoaded()) {
            log.warn((Object)"Database not start ! Could not update the schema.");
            return;
        }
        try {
            Version actualDbVersion = databaseSchemaService.getDbVersion();
            log.info((Object)("Database schema version is: " + actualDbVersion.toString()));
            Version expectedDbVersion = databaseSchemaService.getApplicationVersion();
            log.info((Object)("Database schema version AFTER the update should be: " + expectedDbVersion.toString()));
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)"Error while getting versions.", (Throwable)e);
        }
        try {
            log.info((Object)"Launching update...");
            databaseSchemaService.updateSchema();
            log.info((Object)"Database schema successfullly updated.");
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)"Error while updating the database schema.", (Throwable)e);
        }
    }
}

