/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.test;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.config.AdagioConfigurationOption;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.ServiceLocator;
import fr.ifremer.adagio.core.test.TestUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.i18n.init.UserI18nInitializer;

public abstract class DatabaseResource
implements TestRule {
    protected static final Log log = LogFactory.getLog(DatabaseResource.class);
    public static final String BUILD_ENVIRONMENT_DEFAULT = "hsqldb";
    public static final String HSQLDB_SRC_DATABASE_DIRECTORY = "src/test/db";
    public static final String HSQLDB_SRC_DATABASE_CREATE_SCRIPT = "src/test/db/allegro.script";
    public static long BUILD_TIMESTAMP = System.nanoTime();
    private File resourceDirectory;
    private String dbDirectory;
    protected final String beanFactoryReferenceLocation;
    protected final String beanRefFactoryReferenceId;
    private final boolean writeDb;
    private String configName;
    private boolean witherror = false;
    protected Class<?> testClass;
    protected final Set<File> toDestroy = Sets.newHashSet();

    protected DatabaseResource(String configName, String beanFactoryReferenceLocation, String beanRefFactoryReferenceId, boolean writeDb) {
        this.configName = configName;
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation;
        this.beanRefFactoryReferenceId = beanRefFactoryReferenceId;
        this.writeDb = writeDb;
    }

    protected abstract String getConfigFilesPrefix();

    public File getResourceDirectory(String name) {
        return new File(this.resourceDirectory, name);
    }

    public File getResourceDirectory() {
        return this.resourceDirectory;
    }

    protected boolean isWriteDb() {
        return this.writeDb;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                DatabaseResource.this.before(description);
                try {
                    base.evaluate();
                }
                catch (Throwable e) {
                    DatabaseResource.this.witherror = true;
                }
                finally {
                    DatabaseResource.this.after(description);
                }
            }
        };
    }

    protected void before(Description description) throws Throwable {
        this.testClass = description.getTestClass();
        boolean prepareDb = this.beanFactoryReferenceLocation == null || !this.beanFactoryReferenceLocation.contains("WithNoDb");
        boolean defaultDbName = StringUtils.isEmpty((CharSequence)this.configName);
        this.dbDirectory = null;
        if (defaultDbName) {
            this.configName = "db";
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Prepare test " + this.testClass));
        }
        this.resourceDirectory = DatabaseResource.getTestSpecificDirectory(this.testClass, "");
        String buildEnvironment = this.getBuildEnvironment();
        String configFilename = this.getConfigFilesPrefix();
        if (prepareDb) {
            configFilename = configFilename + "-" + (this.writeDb ? "write" : "read");
        }
        if (!defaultDbName) {
            configFilename = configFilename + "-" + this.configName;
        }
        String configFilenameNoEnv = configFilename + ".properties";
        if (StringUtils.isNotBlank((CharSequence)buildEnvironment)) {
            configFilename = configFilename + "-" + buildEnvironment;
        }
        configFilename = configFilename + ".properties";
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + configFilename);
        if (resourceAsStream == null && StringUtils.isNotBlank((CharSequence)buildEnvironment)) {
            resourceAsStream = this.getClass().getResourceAsStream("/" + configFilenameNoEnv);
            Preconditions.checkNotNull((Object)resourceAsStream, (Object)("Could not find " + configFilename + " or " + configFilenameNoEnv + " in test class-path"));
            configFilename = configFilenameNoEnv;
        } else {
            Preconditions.checkNotNull((Object)resourceAsStream, (Object)("Could not find " + configFilename + " in test class-path"));
        }
        if (prepareDb && BUILD_ENVIRONMENT_DEFAULT.equalsIgnoreCase(buildEnvironment)) {
            this.dbDirectory = HSQLDB_SRC_DATABASE_DIRECTORY;
            if (!defaultDbName) {
                this.dbDirectory = this.dbDirectory + this.configName;
            }
            TestUtil.checkDbExists(this.testClass, this.dbDirectory);
            if (this.writeDb) {
                boolean serverMode;
                Properties p = new Properties();
                p.load(resourceAsStream);
                String jdbcUrl = p.getProperty(AdagioConfigurationOption.JDBC_URL.getKey());
                boolean bl = serverMode = jdbcUrl != null && jdbcUrl.startsWith("jdbc:hsqldb:hsql://");
                if (serverMode) {
                    log.warn((Object)String.format("Database running in server mode ! Please remove the property '%s' in file %s, to use a file database.", AdagioConfigurationOption.JDBC_URL.getKey(), configFilename));
                } else {
                    this.copyDb(new File(this.dbDirectory), "db", !this.writeDb, null);
                    this.dbDirectory = new File(this.resourceDirectory, "db").getAbsolutePath();
                    this.dbDirectory = this.dbDirectory.replaceAll("[\\\\]", "/");
                }
            } else {
                File dbConfig = new File(this.dbDirectory, "allegro.properties");
                Properties p = new Properties();
                BufferedReader reader = Files.newReader((File)dbConfig, (Charset)Charsets.UTF_8);
                p.load(reader);
                reader.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Db config: " + dbConfig + "\n" + p));
                }
                String readonly = p.getProperty("readonly");
                Preconditions.checkNotNull((Object)readonly, (Object)("Could not find readonly property on db confg: " + dbConfig));
                Preconditions.checkState((boolean)"true".equals(readonly), (Object)("readonly property must be at true value in read mode test in  db confg: " + dbConfig));
            }
        }
        this.initConfiguration(configFilename);
        this.initI18n();
        if (this.beanFactoryReferenceLocation != null) {
            ServiceLocator.instance().init(this.beanFactoryReferenceLocation, this.beanRefFactoryReferenceId);
        }
    }

    public void addToDestroy(File dir) {
        this.toDestroy.add(dir);
    }

    public void setProperty(File file, String key, String value) throws IOException {
        Properties props = new Properties();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        props.load(reader);
        reader.close();
        props.setProperty(key, value);
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        props.store(writer, "");
        writer.close();
    }

    public void copyDb(File sourceDirectory, String targetDbDirectoryName, boolean readonly, Properties p) throws IOException {
        File targetDirectory = this.getResourceDirectory(targetDbDirectoryName);
        this.copyDb(sourceDirectory, targetDirectory, readonly, p, true);
    }

    public void copyDb(File sourceDirectory, File targetDirectory, boolean readonly, Properties p, boolean destroyAfterTest) throws IOException {
        if (!sourceDirectory.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find db at " + sourceDirectory + ", test [" + this.testClass + "] is skipped."));
            }
            Assume.assumeTrue((boolean)false);
        }
        if (p != null) {
            String jdbcUrl = DaoUtils.getJdbcUrl(targetDirectory, "allegro");
            DaoUtils.fillConnectionProperties(p, jdbcUrl, "SA", "");
        }
        if (destroyAfterTest) {
            this.addToDestroy(targetDirectory);
        }
        log.debug((Object)String.format("Copy directory %s at %s", sourceDirectory.getPath(), targetDirectory.getPath()));
        FileUtils.copyDirectory((File)sourceDirectory, (File)targetDirectory);
        log.debug((Object)String.format("Set database properties with readonly=%s", readonly));
        File dbConfig = new File(targetDirectory, "allegro.properties");
        this.setProperty(dbConfig, "readonly", String.valueOf(readonly));
    }

    protected void after(Description description) throws IOException {
        ServiceLocator serviceLocator;
        if (log.isInfoEnabled()) {
            log.info((Object)("After test " + this.testClass));
        }
        if ((serviceLocator = ServiceLocator.instance()).isOpen()) {
            Properties connectionProperties = AdagioConfiguration.getInstance().getConnectionProperties();
            try {
                DaoUtils.shutdownDatabase(connectionProperties);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Could not close database.", (Throwable)e);
                }
                this.witherror = true;
            }
            serviceLocator.shutdown();
        }
        if (!this.witherror) {
            for (File file : this.toDestroy) {
                if (!file.exists()) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Destroy directory: " + file));
                }
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Could not delete directory: " + file), (Throwable)e);
                }
            }
        }
        if (this.beanFactoryReferenceLocation != null) {
            ServiceLocator.instance().init(null, null);
        }
    }

    public Connection createEmptyDb(String dbDirectory, String dbName) throws IOException, SQLException {
        return this.createEmptyDb(dbDirectory, dbName, null);
    }

    public Connection createEmptyDb(String dbDirectory, String dbName, Properties p) throws IOException, SQLException {
        File externalDbFile = this.getResourceDirectory(dbDirectory);
        return this.createEmptyDb(externalDbFile, dbName, p);
    }

    public static File getTestSpecificDirectory(Class<?> testClass, String name) throws IOException {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            tempDirPath = "";
            if (log.isWarnEnabled()) {
                log.warn((Object)"'\"java.io.tmpdir\" not defined");
            }
        }
        File tempDirFile = new File(tempDirPath);
        String dataBasePath = testClass.getName() + File.separator + name + '_' + BUILD_TIMESTAMP;
        File databaseFile = new File(tempDirFile, dataBasePath);
        FileUtils.forceMkdir((File)databaseFile);
        return databaseFile;
    }

    public Connection createEmptyDb(File directory, String dbName) throws SQLException, IOException {
        return this.createEmptyDb(directory, dbName, null);
    }

    public Connection createEmptyDb(File directory, String dbName, Properties p) throws SQLException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Create new db at " + directory));
        }
        this.addToDestroy(directory);
        String jdbcUrl = DaoUtils.getJdbcUrl(directory, dbName);
        String user = "SA";
        String password = "";
        if (p != null) {
            DaoUtils.fillConnectionProperties(p, jdbcUrl, user, password);
        }
        File scriptFile = new File(HSQLDB_SRC_DATABASE_CREATE_SCRIPT);
        Preconditions.checkState((boolean)scriptFile.exists(), (Object)("Could not find db script at " + scriptFile));
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use create script: " + scriptFile));
        }
        Connection connection = DaoUtils.createConnection(jdbcUrl, user, password);
        if (log.isInfoEnabled()) {
            log.info((Object)("Created connection at " + connection.getMetaData().getURL()));
        }
        List<String> importScriptSql = this.getImportScriptSql(scriptFile);
        for (String sql : importScriptSql) {
            try {
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.execute();
            }
            catch (SQLException sqle) {
                log.warn((Object)("SQL command failed : " + sql), (Throwable)sqle);
                connection.close();
                throw sqle;
            }
        }
        connection.commit();
        return connection;
    }

    protected List<String> getImportScriptSql(File scriptFile) throws IOException {
        List lines = Files.readLines((File)scriptFile, (Charset)Charsets.UTF_8);
        ArrayList result = Lists.newArrayListWithCapacity((int)lines.size());
        Predicate<String> predicate = new Predicate<String>(){
            Set<String> forbiddenStarts = Sets.newHashSet((Object[])new String[]{"SET ", "CREATE USER ", "CREATE SCHEMA ", "GRANT DBA TO "});

            public boolean apply(String input) {
                boolean accept = true;
                for (String forbiddenStart : this.forbiddenStarts) {
                    if (!input.startsWith(forbiddenStart)) continue;
                    accept = false;
                    break;
                }
                return accept;
            }
        };
        for (String line : lines) {
            if (!predicate.apply((Object)line.trim().toUpperCase())) continue;
            if (line.contains("\\u000a")) {
                line = line.replaceAll("\\\\u000a", "\n");
            }
            result.add(line);
        }
        return result;
    }

    public String getBuildEnvironment() {
        return this.getBuildEnvironment(null);
    }

    protected String getBuildEnvironment(String defaultEnvironement) {
        String buildEnv = System.getProperty("env");
        if (buildEnv == null && StringUtils.isNotBlank((CharSequence)defaultEnvironement)) {
            buildEnv = defaultEnvironement;
            log.warn((Object)("Could not find build environment. Please add -Denv=<hsqldb|oracle|pgsql>. Test [" + this.testClass + "] will use default environment : " + defaultEnvironement));
        } else if (!(BUILD_ENVIRONMENT_DEFAULT.equals(buildEnv) || "oracle".equals(buildEnv) || "pgsql".equals(buildEnv))) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find build environment. Please add -Denv=<hsqldb|oracle|pgsql>. Test [" + this.testClass + "] will be skipped."));
            }
            Assume.assumeTrue((boolean)false);
        }
        return buildEnv;
    }

    protected String[] getConfigArgs() {
        ArrayList configArgs = Lists.newArrayList();
        configArgs.addAll(Lists.newArrayList((Object[])new String[]{"--option", "adagio.basedir", this.resourceDirectory.getAbsolutePath()}));
        if (this.dbDirectory != null) {
            configArgs.addAll(Lists.newArrayList((Object[])new String[]{"--option", "adagio.persistence.db.directory", this.dbDirectory}));
        }
        return configArgs.toArray(new String[configArgs.size()]);
    }

    protected void initConfiguration(String configFilename) {
        String[] configArgs = this.getConfigArgs();
        AdagioConfiguration config = new AdagioConfiguration(configFilename, configArgs);
        AdagioConfiguration.setInstance(config);
    }

    protected void initI18n() throws IOException {
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        File i18nDirectory = new File(config.getDataDirectory(), "i18n");
        if (i18nDirectory.exists()) {
            FileUtils.cleanDirectory((File)i18nDirectory);
        }
        FileUtils.forceMkdir((File)i18nDirectory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("I18N directory: " + i18nDirectory));
        }
        Locale i18nLocale = config.getI18nLocale();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts i18n with locale [%s] at [%s]", i18nLocale, i18nDirectory));
        }
        I18n.init((I18nInitializer)new UserI18nInitializer(i18nDirectory, new DefaultI18nInitializer(this.getI18nBundleName())), (Locale)i18nLocale);
    }

    protected String getI18nBundleName() {
        return "adagio-core-shared-i18n";
    }
}

