/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical.sanity.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.vessel.VesselRegistrationPeriodImpl;
import fr.ifremer.adagio.core.service.technical.sanity.task.DatabaseSanityTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class DatabaseSanityTaskVesselRegistrationPeriod
implements DatabaseSanityTask {
    private static final Log log = LogFactory.getLog(DatabaseSanityTaskVesselRegistrationPeriod.class);

    @Override
    public Set<String> sanity(Session currentSession) {
        HashSet cacheIds = Sets.newHashSet();
        Query query = currentSession.createQuery("SELECT vesselRegistrationPeriodPk.vessel.code FROM " + VesselRegistrationPeriodImpl.class.getName() + " WHERE endDateTime IS NULL GROUP BY vesselRegistrationPeriodPk.vessel.code HAVING COUNT(*)>1");
        List vesselCodes = query.list();
        if (CollectionUtils.isEmpty((Collection)vesselCodes)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"vesselRegistrationPeriods are sane");
            }
            return cacheIds;
        }
        for (String vesselCode : vesselCodes) {
            Query query1 = currentSession.createQuery("SELECT vesselRegistrationPeriodPk FROM " + VesselRegistrationPeriodImpl.class.getName() + " WHERE endDateTime IS NULL AND vesselRegistrationPeriodPk.vessel.code = :vesselCode ORDER BY vesselRegistrationPeriodPk.startDateTime DESC").setString("vesselCode", vesselCode);
            ArrayList vesselRegistrationPeriods = Lists.newArrayList((Iterable)query1.list());
            vesselRegistrationPeriods.remove(0);
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Remove %d bad VesselRegistrationPeriod for vessel: %s", vesselRegistrationPeriods.size(), vesselCode));
            }
            currentSession.createQuery("DELETE FROM " + VesselRegistrationPeriodImpl.class.getName() + " WHERE vesselRegistrationPeriodPk in :vesselRegistrationPeriodPk").setParameterList("vesselRegistrationPeriodPk", (Collection)vesselRegistrationPeriods).executeUpdate();
        }
        currentSession.setFlushMode(FlushMode.COMMIT);
        currentSession.flush();
        cacheIds.add("fishingVessels");
        cacheIds.add("vesselByCode");
        return cacheIds;
    }
}

