/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionAccess;
import com.intel.bluetooth.BluetoothRFCommInputStream;
import com.intel.bluetooth.BluetoothRFCommOutputStream;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.StreamConnection;

abstract class BluetoothRFCommConnection
implements StreamConnection,
BluetoothConnectionAccess {
    protected BluetoothStack bluetoothStack;
    protected volatile long handle;
    private BluetoothRFCommInputStream in;
    private BluetoothRFCommOutputStream out;
    private boolean isClosed;
    protected int securityOpt;
    RemoteDevice remoteDevice;

    protected BluetoothRFCommConnection(BluetoothStack bluetoothStack, long handle) {
        this.bluetoothStack = bluetoothStack;
        this.handle = handle;
        this.isClosed = false;
    }

    abstract void closeConnectionHandle(long var1) throws IOException;

    void streamClosed() throws IOException {
        if (!this.isClosed) {
            return;
        }
        if (this.in != null && !this.in.isClosed()) {
            return;
        }
        if (this.out != null && !this.out.isClosed()) {
            return;
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        if (this.handle != 0L) {
            long synchronizedHandle;
            DebugLog.debug("closing RFCOMM Connection", this.handle);
            BluetoothRFCommConnection bluetoothRFCommConnection = this;
            synchronized (bluetoothRFCommConnection) {
                synchronizedHandle = this.handle;
                this.handle = 0L;
            }
            if (synchronizedHandle != 0L) {
                this.closeConnectionHandle(synchronizedHandle);
            }
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("RFCOMM Connection is already closed");
        }
        if (this.in == null) {
            this.in = new BluetoothRFCommInputStream(this);
            return this.in;
        }
        if (this.in.isClosed()) {
            throw new IOException("Stream cannot be reopened");
        }
        throw new IOException("Another InputStream already opened");
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("RFCOMM Connection is already closed");
        }
        if (this.out == null) {
            this.out = new BluetoothRFCommOutputStream(this);
            return this.out;
        }
        if (this.out.isClosed()) {
            throw new IOException("Stream cannot be reopened");
        }
        throw new IOException("Another OutputStream already opened");
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.streamClosed();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void markAuthenticated() {
        if (this.securityOpt == 0) {
            this.securityOpt = 1;
        }
    }

    public int getSecurityOpt() {
        try {
            this.securityOpt = this.bluetoothStack.rfGetSecurityOpt(this.handle, this.securityOpt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.securityOpt;
    }

    public boolean encrypt(long address, boolean on) throws IOException {
        if (this.isClosed) {
            throw new IOException("RFCOMM Connection is already closed");
        }
        boolean changed = this.bluetoothStack.rfEncrypt(address, this.handle, on);
        if (changed) {
            this.securityOpt = on ? 2 : 1;
        }
        return changed;
    }

    public long getRemoteAddress() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection closed");
        }
        return this.bluetoothStack.getConnectionRfRemoteAddress(this.handle);
    }

    public RemoteDevice getRemoteDevice() {
        return this.remoteDevice;
    }

    public void setRemoteDevice(RemoteDevice remoteDevice) {
        this.remoteDevice = remoteDevice;
    }

    public BluetoothStack getBluetoothStack() {
        return this.bluetoothStack;
    }
}

