/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.net.URL;
import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.command.CssReloadedEvent;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.CssRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

public class CssCommand
extends AbstractElementCommand {
    private static final int APPEND_POS = -1;

    public CssCommand(Module module, DesignElement element) {
        super(module, element);
    }

    public void addCss(String fileName) throws SemanticException {
        IncludedCssStyleSheet cssStruct = StructureFactory.createIncludedCssStyleSheet();
        cssStruct.setFileName(fileName);
        this.addCss(cssStruct);
    }

    public void addCssByProperties(String fileName, String externalCssURI, boolean isUseExternalCss) throws SemanticException {
        IncludedCssStyleSheet cssStruct = StructureFactory.createIncludedCssStyleSheet();
        cssStruct.setFileName(fileName);
        cssStruct.setExternalCssURI(externalCssURI);
        cssStruct.setUseExternalCss(isUseExternalCss);
        this.addCss(cssStruct);
    }

    public void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        String fileName = cssStruct.getFileName();
        CssStyleSheet sheet = null;
        String externalCSSURI = cssStruct.getExternalCssURI();
        if (fileName == null && (externalCSSURI != null || cssStruct.isUseExternalCss())) {
            sheet = new CssStyleSheet();
            if (externalCSSURI != null) {
                sheet.setExternalCssURI(externalCSSURI);
            }
            sheet.setUseExternalCss(true);
            sheet.setContainer(this.module);
        } else {
            try {
                sheet = this.module.loadCss(fileName);
            }
            catch (StyleSheetException e) {
                throw ModelUtil.convertSheetExceptionToCssException(this.module, cssStruct, fileName, e);
            }
        }
        this.doAddCssSheet(cssStruct, sheet, -1);
    }

    public void addCss(CssStyleSheet sheet) throws SemanticException {
        if (sheet == null) {
            return;
        }
        String fileName = sheet.getFileName();
        String externalCssURI = sheet.getExternalCssURI();
        boolean useExternalCss = sheet.isUseExternalCss();
        if (fileName != null && this.getCssStyleSheetByProperties(fileName, externalCssURI, useExternalCss) != null) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.DUPLICATE_CSS");
        }
        IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
        css.setFileName(sheet.getFileName());
        css.setExternalCssURI(sheet.getExternalCssURI());
        css.setUseExternalCss(sheet.isUseExternalCss());
        this.doAddCssSheet(css, sheet, -1);
    }

    private void doAddCssStruct(IncludedCssStyleSheet css, int posn) throws SemanticException {
        assert (css != null);
        String propName = this.getCssPropertyName();
        assert (propName != null);
        ElementPropertyDefn propDefn = this.element.getPropertyDefn(propName);
        ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.element);
        if (posn == -1) {
            propCommand.addItem(new StructureContext(this.element, propDefn, null), (Object)css);
        } else {
            propCommand.insertItem(new StructureContext(this.element, propDefn, null), css, posn);
        }
    }

    private void doAddCssSheet(IncludedCssStyleSheet cssStruct, CssStyleSheet sheet, int posn) throws SemanticException {
        if (cssStruct == null || sheet == null) {
            return;
        }
        ActivityStack activityStack = this.getActivityStack();
        CssRecord record = null;
        record = posn == -1 ? new CssRecord(this.module, this.element, sheet, true) : new CssRecord(this.module, this.element, sheet, true, posn);
        activityStack.startTrans(record.getLabel());
        this.getActivityStack().execute(record);
        try {
            this.doAddCssStruct(cssStruct, posn);
        }
        catch (SemanticException e) {
            activityStack.rollback();
            throw e;
        }
        activityStack.commit();
    }

    public void dropCss(CssStyleSheet sheet) throws SemanticException {
        if (sheet == null) {
            return;
        }
        String fileName = sheet.getFileName();
        IncludedCssStyleSheet css = this.getIncludedCssStyleSheetByProperties(sheet.getFileName(), sheet.getExternalCssURI(), sheet.isUseExternalCss());
        ICssStyleSheetOperation cssOperation = (ICssStyleSheetOperation)((Object)this.element);
        int position = cssOperation.getCsses().indexOf(sheet);
        if (css == null || position == -1) {
            throw new CssException(this.module, css, new String[]{fileName}, "Error.CSSException.CSS_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        CssRecord record = new CssRecord(this.module, this.element, sheet, false, position);
        stack.startTrans(record.getLabel());
        this.getActivityStack().execute(record);
        this.removeIncludeCss(css);
        this.getActivityStack().commit();
    }

    private String getCssPropertyName() {
        if (this.element instanceof ReportDesign) {
            return "cssStyleSheets";
        }
        if (this.element instanceof AbstractTheme) {
            return "cssStyleSheets";
        }
        return null;
    }

    private void removeIncludeCss(IncludedCssStyleSheet css) throws SemanticException {
        String propName = this.getCssPropertyName();
        assert (propName != null);
        ElementPropertyDefn propDefn = this.element.getPropertyDefn(propName);
        ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.element);
        propCommand.removeItem(new StructureContext(this.element, propDefn, null), css);
    }

    private CssStyleSheet getCssStyleSheetByLocation(String location) {
        ICssStyleSheetOperation sheet = (ICssStyleSheetOperation)((Object)this.element);
        List<CssStyleSheet> csses = sheet.getCsses();
        URL url = this.module.findResource(location, 3);
        if (url == null) {
            return null;
        }
        return CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, csses, url);
    }

    private CssStyleSheet getCssStyleSheetByProperties(String fileName, String externalCssURI, boolean isUseExternalCss) {
        ICssStyleSheetOperation sheet = (ICssStyleSheetOperation)((Object)this.element);
        List<CssStyleSheet> csses = sheet.getCsses();
        URL url = null;
        if (fileName != null) {
            url = this.module.findResource(fileName, 3);
        }
        return CssStyleSheetAdapter.getCssStyleSheetByProperties(this.module, csses, url, externalCssURI, isUseExternalCss);
    }

    public IncludedCssStyleSheet getIncludedCssStyleSheetByProperties(String fileName, String externalCssURI, boolean isUseExternalCss) {
        ICssStyleSheetOperation sheet = (ICssStyleSheetOperation)((Object)this.element);
        List<CssStyleSheet> csses = sheet.getCsses();
        int position = CssStyleSheetAdapter.getPositionOfCssStyleSheetByProperties(this.module, csses, fileName, externalCssURI, isUseExternalCss);
        if (position == -1) {
            return null;
        }
        String propName = this.getCssPropertyName();
        assert (propName != null);
        List<Object> cssStructs = this.element.getListProperty(this.module, propName);
        return (IncludedCssStyleSheet)cssStructs.get(position);
    }

    public IncludedCssStyleSheet getIncludedCssStyleSheetByLocation(String location) {
        if (location == null) {
            return null;
        }
        ICssStyleSheetOperation sheet = (ICssStyleSheetOperation)((Object)this.element);
        List<CssStyleSheet> csses = sheet.getCsses();
        int position = CssStyleSheetAdapter.getPositionOfCssStyleSheet(this.module, csses, location);
        if (position == -1) {
            return null;
        }
        String propName = this.getCssPropertyName();
        assert (propName != null);
        List<Object> cssStructs = this.element.getListProperty(this.module, propName);
        return (IncludedCssStyleSheet)cssStructs.get(position);
    }

    public void reloadCss(CssStyleSheet sheet) throws SemanticException {
        if (sheet == null) {
            return;
        }
        IncludedCssStyleSheet cssSheet = this.getIncludedCssStyleSheetByProperties(sheet.getFileName(), sheet.getExternalCssURI(), sheet.isUseExternalCss());
        String fileName = cssSheet.getFileName();
        String externalCssURI = cssSheet.getExternalCssURI();
        boolean useExternalCss = cssSheet.isUseExternalCss();
        ActivityStack stack = this.module.getActivityStack();
        stack.startSilentTrans(true);
        CssStyleSheet newStyleSheet = null;
        try {
            int posn = this.findIncludedCssStyleSheetPosition(sheet);
            this.dropCss(sheet);
            if (fileName != null) {
                try {
                    newStyleSheet = this.module.loadCss(fileName);
                    newStyleSheet.setExternalCssURI(externalCssURI);
                    newStyleSheet.setUseExternalCss(useExternalCss);
                }
                catch (StyleSheetException styleSheetException) {
                    newStyleSheet = null;
                }
            } else {
                newStyleSheet = new CssStyleSheet();
                newStyleSheet.setExternalCssURI(externalCssURI);
                newStyleSheet.setUseExternalCss(useExternalCss);
            }
            IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
            css.setFileName(sheet.getFileName());
            css.setExternalCssURI(externalCssURI);
            css.setUseExternalCss(useExternalCss);
            if (newStyleSheet == null) {
                this.doAddCssStruct(css, posn);
            }
            this.doAddCssSheet(css, newStyleSheet, posn);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        this.doPostReloadAction(newStyleSheet);
    }

    private int findIncludedCssStyleSheetPosition(CssStyleSheet sheet) {
        return this.findIncludedCssStyleSheetPositionByProperties(sheet.getFileName(), sheet.getExternalCssURI(), sheet.isUseExternalCss());
    }

    private IncludedCssStyleSheet findIncludedCssStyleSheet(CssStyleSheet sheet) {
        String propName = this.getCssPropertyName();
        assert (propName != null);
        List<Object> includedCss = this.element.getListProperty(this.module, propName);
        int posn = this.findIncludedCssStyleSheetPosition(sheet);
        if (posn == -1) {
            return null;
        }
        return (IncludedCssStyleSheet)includedCss.get(posn);
    }

    private int findIncludedCssStyleSheetPosition(String fileName) {
        String propName = this.getCssPropertyName();
        assert (propName != null);
        List<Object> includedCss = this.element.getListProperty(this.module, propName);
        int i = 0;
        while (i < includedCss.size()) {
            IncludedCssStyleSheet oneCss = (IncludedCssStyleSheet)includedCss.get(i);
            assert (oneCss.getFileName() != null);
            if (oneCss.getFileName().equalsIgnoreCase(fileName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findIncludedCssStyleSheetPositionByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        String propName = this.getCssPropertyName();
        assert (propName != null);
        List<Object> includedCss = this.element.getListProperty(this.module, propName);
        int i = 0;
        while (i < includedCss.size()) {
            IncludedCssStyleSheet oneCss = (IncludedCssStyleSheet)includedCss.get(i);
            if (oneCss.getFileName() != null ? oneCss.getFileName().equalsIgnoreCase(fileName) : (oneCss.getExternalCssURI() != null ? oneCss.getExternalCssURI().equals(externalCssURI) : externalCssURI == null && oneCss.isUseExternalCss() && useExternalCss)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void doPostReloadAction(CssStyleSheet css) {
        CssReloadedEvent event = new CssReloadedEvent(this.module, css);
        this.module.broadcast(event);
        ActivityStack activityStack = this.module.getActivityStack();
        activityStack.commit();
        activityStack.flush();
        this.module.setSaveState(0);
        activityStack.sendNotifcations(new ActivityStackEvent(activityStack, 1));
        this.module.getModuleHandle().checkReport();
    }

    public IncludedCssStyleSheet checkRenameCss(IncludedCssStyleSheet includedCssSheet, String newFileName) throws CssException {
        if (!this.element.canEdit(this.module)) {
            throw new CssException(this.module, new String[]{newFileName}, "Error.CssException.READONLY");
        }
        URL url = this.module.findResource(newFileName, 3);
        if (url == null) {
            throw new CssException(this.module, new String[]{newFileName}, "Error.CSSException.CSS_NOT_FOUND");
        }
        CssStyleSheet sheet = CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), url);
        if (sheet != null) {
            IncludedCssStyleSheet tmpIncludedCssStyleSheet = this.findIncludedCssStyleSheet(sheet);
            if (includedCssSheet != tmpIncludedCssStyleSheet) {
                throw new CssException(this.module, new String[]{newFileName}, "Error.CSSException.DUPLICATE_CSS");
            }
            return tmpIncludedCssStyleSheet;
        }
        return null;
    }

    public IncludedCssStyleSheet checkRenameCssByProperties(IncludedCssStyleSheet includedCssSheet, String fileName, String externalCssURI, boolean useExternalCss) throws CssException {
        CssStyleSheet sheet;
        if (!this.element.canEdit(this.module)) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CssException.READONLY");
        }
        URL url = null;
        if (fileName != null) {
            url = this.module.findResource(fileName, 3);
        }
        if ((sheet = CssStyleSheetAdapter.getCssStyleSheetByProperties(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), url, externalCssURI, useExternalCss)) != null) {
            IncludedCssStyleSheet tmpIncludedCssStyleSheet = this.findIncludedCssStyleSheet(sheet);
            if (includedCssSheet != tmpIncludedCssStyleSheet) {
                throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.DUPLICATE_CSS");
            }
            return tmpIncludedCssStyleSheet;
        }
        return null;
    }

    public void renameCss(IncludedCssStyleSheet includedCssStyleSheet, String newFileName) throws SemanticException {
        if (includedCssStyleSheet == null || newFileName == null) {
            return;
        }
        if (includedCssStyleSheet.getFileName().equals(newFileName)) {
            return;
        }
        IncludedCssStyleSheet foundIncludedCssStyleSheet = this.checkRenameCss(includedCssStyleSheet, newFileName);
        if (foundIncludedCssStyleSheet == includedCssStyleSheet) {
            return;
        }
        String externalCssURI = includedCssStyleSheet.getExternalCssURI();
        String fileName = includedCssStyleSheet.getFileName();
        CssStyleSheet sheet = this.getCssStyleSheetByLocation(fileName);
        IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
        css.setFileName(newFileName);
        css.setExternalCssURI(externalCssURI);
        int posn = this.findIncludedCssStyleSheetPosition(fileName);
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.RenameCSSFile"));
        CssStyleSheet newStyleSheet = null;
        try {
            if (sheet == null) {
                this.removeIncludeCss(includedCssStyleSheet);
            } else {
                this.dropCss(sheet);
            }
            try {
                newStyleSheet = this.module.loadCss(newFileName);
            }
            catch (StyleSheetException styleSheetException) {
                newStyleSheet = null;
            }
            if (newStyleSheet == null) {
                this.doAddCssStruct(css, posn);
            }
            this.doAddCssSheet(css, newStyleSheet, posn);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void renameCssByProperties(IncludedCssStyleSheet includedCssStyleSheet, String newFileName, String newExternalCssURI, boolean newUseExternalCss) throws SemanticException {
        if (includedCssStyleSheet == null) {
            return;
        }
        IncludedCssStyleSheet foundIncludedCssStyleSheet = this.checkRenameCssByProperties(includedCssStyleSheet, newFileName, newExternalCssURI, newUseExternalCss);
        if (foundIncludedCssStyleSheet == includedCssStyleSheet) {
            return;
        }
        String externalCssURI = includedCssStyleSheet.getExternalCssURI();
        String fileName = includedCssStyleSheet.getFileName();
        boolean useExternalCss = includedCssStyleSheet.isUseExternalCss();
        CssStyleSheet sheet = this.getCssStyleSheetByProperties(fileName, externalCssURI, useExternalCss);
        IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
        css.setFileName(newFileName);
        css.setExternalCssURI(newExternalCssURI);
        css.setUseExternalCss(newUseExternalCss);
        int posn = this.findIncludedCssStyleSheetPositionByProperties(fileName, externalCssURI, useExternalCss);
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.RenameCSSFile"));
        CssStyleSheet newStyleSheet = null;
        try {
            if (sheet == null) {
                this.removeIncludeCss(includedCssStyleSheet);
            } else {
                this.dropCss(sheet);
            }
            if (newFileName != null) {
                try {
                    newStyleSheet = this.module.loadCss(newFileName);
                }
                catch (StyleSheetException styleSheetException) {
                    newStyleSheet = null;
                }
            } else {
                newStyleSheet = new CssStyleSheet();
                newStyleSheet.setContainer(this.module);
            }
            newStyleSheet.setExternalCssURI(newExternalCssURI);
            newStyleSheet.setUseExternalCss(newUseExternalCss);
            this.doAddCssSheet(css, newStyleSheet, posn);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

