/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.CatchExportRow;
import fr.ifremer.tutti.service.export.generic.ExportSampleCategory;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.csv.ValueFormatter;

public class CatchExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<CatchExportRow> {
    public static final String WEIGHT_OR_VOL_TYPE = "Poids";
    protected SampleCategoryModel sampleCategoryModel;

    public CatchExportModel(char separator, SampleCategoryModel sampleCategoryModel, DecoratorService decoratorService) {
        super(separator);
        this.sampleCategoryModel = sampleCategoryModel;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newNullableColumnForExport("Engin", "gear.name");
        this.newColumnForExport("Code_station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Code_Taxon", "species.referenceTaxonId", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Code_Espece_Campagne", "species.surveyCode");
        this.newColumnForExport("Nom_scientifique", "species.name");
        this.newColumnForExport("Commentaire", "comment", TuttiCsvUtil.COMMENT_FORMATTER);
        for (SampleCategoryModelEntry entry : sampleCategoryModel.getCategory()) {
            this.addSampleCategory(entry.getCanonicalLabel(), entry.getOrder());
        }
        this.newNullableColumnForExport("Code_Longueur", "frequency.lengthStepCaracteristic.id");
        this.newNullableColumnForExportByDecorator("Libelle_Longueur", "frequency.lengthStepCaracteristic", decoratorService.getDecoratorByType(Caracteristic.class));
        this.newNullableColumnForExport("Taille", "frequency.lengthStep", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("NumOrdre_Taille_H2", "frequency.rankOrder", TuttiCsvUtil.INTEGER);
        this.newNullableColumnForExport("Poids_Classe_Taille", "frequency.weight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Unite_Taille", "frequency.lengthStepCaracteristic.unit");
        this.newNullableColumnForExport("Precision_Mesure", "frequency.lengthStepCaracteristic.precision", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Nbr", "batchNumber", TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poids_Reference", "referenceWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport("Coef_Elev_Espece_Capture", "raisingFactor", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport("Coef_Final_Elevation", "finalRaisingFactor", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
    }

    public void prepareRows(PersistenceService persistenceService, List<CatchExportRow> rows, Cruise cruise, FishingOperation operation, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch, Float speciesCatchRaisingFactor, Float benthosCatchRaisingFactor) {
        float totalBatchWeight;
        Float batchWeight;
        CatchExportRow row;
        Caracteristic weightMeasuredCaracteristic = persistenceService.getWeightMeasuredCaracteristic();
        String batchWeightUnit = weightMeasuredCaracteristic.getUnit();
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(speciesBatch.getSpecies());
            row.setBatchWeightUnit(batchWeightUnit);
            if (!persistenceService.isVracBatch((SpeciesAbleBatch)speciesBatch)) {
                speciesCatchRaisingFactor = Float.valueOf(1.0f);
            }
            totalBatchWeight = (batchWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight())) == null ? 0.0f : speciesCatchRaisingFactor.floatValue() * batchWeight.floatValue();
            this.prepareRows(persistenceService, row, rows, speciesBatch, totalBatchWeight);
        }
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(benthosBatch.getSpecies());
            row.setBatchWeightUnit(batchWeightUnit);
            if (!persistenceService.isVracBatch((SpeciesAbleBatch)benthosBatch)) {
                benthosCatchRaisingFactor = Float.valueOf(1.0f);
            }
            totalBatchWeight = (batchWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight())) == null ? 0.0f : benthosCatchRaisingFactor.floatValue() * batchWeight.floatValue();
            this.prepareRows(persistenceService, row, rows, benthosBatch, totalBatchWeight);
        }
        for (CatchExportRow row2 : rows) {
            float finalRaisingFactor = 1.0f;
            for (ExportSampleCategory exportSampleCategory : row2.getSampleCategory()) {
                if (exportSampleCategory == null) continue;
                Float totalWeight = exportSampleCategory.getCategoryWeight();
                Float sampleWeight = exportSampleCategory.getSampleWeight();
                if (totalWeight == null || sampleWeight == null) continue;
                float currentRate = totalWeight.floatValue() / sampleWeight.floatValue();
                finalRaisingFactor *= currentRate;
            }
            row2.setFinalRaisingFactor(finalRaisingFactor);
        }
    }

    protected void prepareRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, SpeciesBatch speciesBatch, float totalBatchWeight) {
        currentRow.addComment(speciesBatch.getComment());
        Integer number = (Integer)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getNumber(), (Number)speciesBatch.getComputedNumber());
        this.prepareBatch(currentRow, speciesBatch.getSampleCategoryId(), speciesBatch.getSampleCategoryValue(), speciesBatch.getSampleCategoryWeight(), speciesBatch.getSampleCategoryComputedWeight(), speciesBatch.getWeight(), number, speciesBatch.getRankOrder());
        if (speciesBatch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> speciesBatchFrequency = persistenceService.getAllSpeciesBatchFrequency(speciesBatch.getId());
            if (CollectionUtils.isEmpty(speciesBatchFrequency)) {
                CatchExportRow row = currentRow.copy();
                Float referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getWeight(), (Number)speciesBatch.getComputedWeight());
                if (referenceWeight == null) {
                    referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                }
                this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                rows.add(row);
            } else {
                boolean withNoWeightOnFrequencies = speciesBatchFrequency.get(0).getWeight() == null;
                Float referenceWeight = null;
                if (withNoWeightOnFrequencies && (referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getWeight(), (Number)speciesBatch.getComputedWeight())) == null) {
                    referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                }
                for (SpeciesBatchFrequency batchFrequency : speciesBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setSpeciesFrequency(batchFrequency);
                    rows.add(row);
                    if (!withNoWeightOnFrequencies) {
                        referenceWeight = batchFrequency.getWeight();
                    }
                    this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                }
            }
        } else {
            for (SpeciesBatch childBatch : speciesBatch.getChildBatchs()) {
                this.prepareRows(persistenceService, currentRow, rows, childBatch, totalBatchWeight);
            }
        }
        currentRow.popLastComment();
    }

    protected void prepareRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, BenthosBatch benthosBatch, float totalBatchWeight) {
        currentRow.addComment(benthosBatch.getComment());
        Integer number = (Integer)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getNumber(), (Number)benthosBatch.getComputedNumber());
        this.prepareBatch(currentRow, benthosBatch.getSampleCategoryId(), benthosBatch.getSampleCategoryValue(), benthosBatch.getSampleCategoryWeight(), benthosBatch.getSampleCategoryComputedWeight(), benthosBatch.getWeight(), number, benthosBatch.getRankOrder());
        if (benthosBatch.isChildBatchsEmpty()) {
            List<BenthosBatchFrequency> benthosBatchFrequency = persistenceService.getAllBenthosBatchFrequency(benthosBatch.getId());
            if (CollectionUtils.isEmpty(benthosBatchFrequency)) {
                CatchExportRow row = currentRow.copy();
                Float referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getWeight(), (Number)benthosBatch.getComputedWeight());
                if (referenceWeight == null) {
                    referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                }
                this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                rows.add(row);
            } else {
                boolean withNoWeightOnFrequencies;
                Float referenceWeight = null;
                boolean bl = withNoWeightOnFrequencies = benthosBatchFrequency.get(0).getWeight() == null;
                if (withNoWeightOnFrequencies && (referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getWeight(), (Number)benthosBatch.getComputedWeight())) == null) {
                    referenceWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                }
                for (BenthosBatchFrequency batchFrequency : benthosBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setBenthosFrequency(batchFrequency);
                    rows.add(row);
                    if (!withNoWeightOnFrequencies) {
                        referenceWeight = batchFrequency.getWeight();
                    }
                    this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                }
            }
        } else {
            for (BenthosBatch childBatch : benthosBatch.getChildBatchs()) {
                this.prepareRows(persistenceService, currentRow, rows, childBatch, totalBatchWeight);
            }
        }
        currentRow.popLastComment();
    }

    protected void setRaisingFactor(CatchExportRow row, float totalBatchWeight, Float referenceWeight) {
        row.setReferenceWeight(referenceWeight);
        row.setRaisingFactor(referenceWeight == null ? 1.0f : totalBatchWeight / referenceWeight.floatValue());
    }

    protected void prepareBatch(CatchExportRow currentRow, Integer sampleCategoryId, Serializable sampleCategoryValue, Float sampleCategoryWeight, Float sampleCategoryComputedWeight, Float batchWeight, Integer batchNumber, Integer batchRankOrder) {
        currentRow.setBatchNumber(batchNumber);
        ExportSampleCategory sampleCategory = new ExportSampleCategory();
        SampleCategoryModelEntry categoryById = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
        sampleCategory.setCategoryDef(categoryById);
        sampleCategory.setCategoryValue(sampleCategoryValue);
        sampleCategory.setCategoryWeight(sampleCategoryWeight);
        sampleCategory.setSampleWeight(batchWeight);
        sampleCategory.setComputedWeight(sampleCategoryComputedWeight);
        sampleCategory.setWeightOrVolType(WEIGHT_OR_VOL_TYPE);
        sampleCategory.setRankOrder(batchRankOrder);
        currentRow.addSampleCategory(sampleCategory);
    }

    protected void addSampleCategory(String headerPrefix, int categoryOrder) {
        String categoryName = "sampleCategory";
        this.newIndexNullableColumnForExport(headerPrefix, categoryName, categoryOrder, "categoryValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newIndexNullableColumnForExport("Num_Ordre_" + headerPrefix + "_H2", categoryName, categoryOrder, "rankOrder", TuttiCsvUtil.INTEGER);
        this.newIndexNullableColumnForExport("Tot_" + headerPrefix, categoryName, categoryOrder, "categoryWeight", TuttiCsvUtil.FLOAT);
        this.newIndexNullableColumnForExport("Ech_" + headerPrefix, categoryName, categoryOrder, "sampleWeight", TuttiCsvUtil.FLOAT);
        this.newIndexNullableColumnForExport("Type_Volume_Poids_" + headerPrefix, categoryName, categoryOrder, "weightOrVolType");
        this.newNullableColumnForExport("Unite_Volume_Poids_" + headerPrefix, "batchWeightUnit");
    }
}

