/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForSampleCategory;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ValidateSampleCategoryAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ValidateSampleCategoryAction.class);

    public ValidateSampleCategoryAction(GenericFormatImportContext importContext) {
        super(importContext);
    }

    @Override
    protected boolean canExecute() {
        return true;
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Validate sample category model.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getSampleCategoryFileResult();
        try (CsvConsumerForSampleCategory consumer = this.importContext.loadSampleCategories(false);){
            int nbCategories = 0;
            for (ImportRow row : consumer) {
                consumer.validateRow(row, this.importContext);
                ++nbCategories;
            }
            if (nbCategories != this.importContext.getImportRequest().getSampleCategoryModel().getNbSampling()) {
                throw new ImportRuntimeException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.missingCategories", (Object[])new Object[0]));
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close sampleCategory.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
    }
}

