/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.csv;

import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterRow;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class MarineLitterModel
extends AbstractTuttiImportExportModel<MarineLitterRow> {
    public static MarineLitterModel forExport(char separator) {
        MarineLitterModel exportModel = new MarineLitterModel(separator);
        exportModel.forExport();
        return exportModel;
    }

    public static MarineLitterModel forImport(char separator, GenericFormatImportEntityParserFactory parserFactory) {
        MarineLitterModel importModel = new MarineLitterModel(separator);
        importModel.forImport(parserFactory);
        return importModel;
    }

    public MarineLitterRow newEmptyInstance() {
        MarineLitterRow row = MarineLitterRow.newEmptyInstance();
        return row;
    }

    protected MarineLitterModel(char separator) {
        super(separator);
    }

    protected void forExport() {
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", TuttiCsvUtil.PROGRAM_FORMATTER);
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Code_Station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Categorie", "marineLitterCategory", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Categorie_Taille", "marineLitterSizeCategory", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Nombre", "number", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poids", "weight", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Commentaire", "comment", (ValueFormatter)TuttiCsvUtil.COMMENT_PARSER_FORMATTER);
        this.newColumnForExport("Serie_Id", "program", TuttiCsvUtil.PROGRAM_TECHNICAL_FORMATTER);
        this.newColumnForExport("Categorie_Id", "marineLitterCategory", TuttiCsvUtil.CARACTERISTIC_VALUE_TECHNICAL_FORMATTER);
        this.newColumnForExport("Categorie_Taille_Id", "marineLitterSizeCategory", TuttiCsvUtil.CARACTERISTIC_VALUE_TECHNICAL_FORMATTER);
    }

    protected void forImport(GenericFormatImportEntityParserFactory parserFactory) {
        this.newMandatoryColumn("Annee", "beginDate", (ValueParser)TuttiCsvUtil.YEAR);
        this.newIgnoredColumn("Serie");
        this.newMandatoryColumn("Serie_Partielle", "surveyPart");
        this.newMandatoryColumn("Code_Station", "stationNumber");
        this.newMandatoryColumn("Id_Operation", "fishingOperationNumber", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Poche", "multirigAggregation");
        this.newIgnoredColumn("Categorie");
        this.newIgnoredColumn("Categorie_Taille");
        this.newMandatoryColumn("Nombre", "number", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Poids", "weight", (ValueParser)TuttiCsvUtil.FLOAT);
        this.newMandatoryColumn("Commentaire", "comment", (ValueParser)TuttiCsvUtil.COMMENT_PARSER_FORMATTER);
        this.newMandatoryColumn("Serie_Id", "program", (ValueParser)parserFactory.getProgramParser());
        this.newMandatoryColumn("Categorie_Id", "marineLitterCategory", (ValueParser)parserFactory.getMarineLitterCategoryValueParser());
        this.newMandatoryColumn("Categorie_Taille_Id", "marineLitterSizeCategory", (ValueParser)parserFactory.getMarineLitterSizeCategoryValueParser());
    }
}

