/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class ImportGenericFormatProgramCruisesAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ImportGenericFormatProgramCruisesAction.class);
    protected File file;

    public ImportGenericFormatProgramCruisesAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(I18n.t((String)"tutti.selectCruise.title.choose.importGenericFormatFile", (Object[])new Object[0]), I18n.t((String)"tutti.selectCruise.action.importGenericformat", (Object[])new Object[0]), new String[]{"^.+\\.zip$", I18n.t((String)"tutti.common.file.zip", (Object[])new Object[0])});
            boolean bl = doAction = this.file != null;
        }
        if (doAction) {
            GenericFormatImportConfiguration importConfiguration = new GenericFormatImportConfiguration();
            importConfiguration.setImportFile(this.file);
            GenericFormatImportService service = this.getContext().getGenericFormatImportService();
            int nbSteps = service.getImportProgramNbSteps(importConfiguration);
            this.createProgressionModelIfRequired(nbSteps);
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Program program = ((SelectCruiseUIModel)this.getModel()).getProgram();
        Preconditions.checkNotNull((Object)program);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import cruises to program " + program.getName() + " from archive: " + this.file));
        }
        GenericFormatImportService service = this.getContext().getGenericFormatImportService();
        ApplicationBusinessException importError = null;
        GenericFormatImportConfiguration importConfiguration = new GenericFormatImportConfiguration();
        importConfiguration.setImportFile(this.file);
        importConfiguration.setProgramId(program.getId());
        try {
            service.importProgram(importConfiguration, this.getProgressionModel());
        }
        catch (ApplicationBusinessException e) {
            String errorMessage = I18n.t((String)"tutti.importProgram.action.importErrors", (Object[])new Object[]{program.getName(), e.getMessage()});
            importError = new ApplicationBusinessException(errorMessage);
        }
        ((SelectCruiseUIHandler)this.handler).resetEditProgramAction();
        this.sendMessage(I18n.t((String)"tutti.importProgram.action.success", (Object[])new Object[]{program.getName(), this.file.getName()}));
        if (importError != null) {
            throw importError;
        }
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }
}

